function onlyAlpha(evt) {
	var e = event || evt; // for trans-browser compatibility
	var charCode = e.which || e.keyCode;

	if ((charCode > 96 && charCode < 123) || (charCode > 64 && charCode < 91) || (charCode == 39) || charCode == 45 || charCode == 9 || charCode == 32) {
		return true;
	} else {
		return false;
	}
}

var scriptURL = "https://brushdentists.com/"; // must set to full path (due to mod_rewrite) - include / at end

var emailValid = "false"; // global e-mail valid check
$(document).ready(function() {
    $('.logo-gallery').hover( function() {
        $(this).find('.img-title').fadeIn(300);
    }, function() {
        $(this).find('.img-title').fadeOut(100);
    });		
	
    // slider for mobile QR code
    $(document).on("click","#mobileQRslider", function(e) {
		e.preventDefault();
		var gotomobileQRimageHeight = (-1)*$('img#gotomobileQRImage').height();
		if ($("#mobileQRpanel").offset().top == 0) {
			$("#mobileQRpanel").animate({top: gotomobileQRimageHeight}, 1000);
			$("#mobileQRslider").addClass("shiftDown");
			$("#mobileQRslider").removeClass("shiftUp");			
		} else {
			$("#mobileQRpanel").animate({top: "0"}, 1000);
			$("#mobileQRslider").removeClass("shiftDown");
			$("#mobileQRslider").addClass("shiftUp");
		}
	});
	
	// set location id variable
	var location_id;
	
	// request an appointment button
	$(document).on("click",".requestApptButton", function(e) {
		e.preventDefault();
		
		// get location data to select the correct e-mail address to send to
		location_id = $(this).data("location_id");	
		
		$("#overlay").fadeIn();
		 jQuery('html, body').animate({scrollTop: 0}, duration);
	});	
	$(document).on("click","#closeRequestForm", function(e) {
		e.preventDefault();
		$("#overlay").fadeOut();
	});
	
    // If the browser supports the Geolocation API
        if (typeof navigator.geolocation == "undefined") {
          $("#error").text("Your browser doesn't support the Geolocation API");
          return;
        }
 
	// If the browser supports the Geolocation API
	if (typeof navigator.geolocation == "undefined") {
		$("#error").text("Your browser doesn't support the Geolocation API");
		return;
	}

	$("#from-link, #to-link").click(function(event) {
		event.preventDefault();
		var addressId = this.id.substring(0, this.id.indexOf("-"));
		
		navigator.geolocation.getCurrentPosition(function(position) {
		var geocoder = new google.maps.Geocoder();
		geocoder.geocode({
			"location": new google.maps.LatLng(position.coords.latitude, position.coords.longitude)
		},
		function(results, status) {
			if (status == google.maps.GeocoderStatus.OK)
				$("#" + addressId).val(results[0].formatted_address);
			else
				$("#error").append("Unable to retrieve your address<br />");
		});
		},
		function(positionError){
			$("#error").append("Error: " + positionError.message + "<br />");
		},
		{
			enableHighAccuracy: true,
			timeout: 10 * 1000 // 10 seconds
		});
	});

	$("#getGoogleDirectionsForm").submit(function(e) {
		e.preventDefault();
		var new_from = $("#from").val();
		new_from = new_from.replace(" ", "+");
		var url = "https://www.google.com/maps/dir/" + new_from + "/" + $("#to").val();
		window.open(url, '_blank');
	});		
	
	// social media links (roller)
	$(document).on("mouseover",".social-media-link", function() {
		var id = $(this).attr("id");
		$("#" + id).slideUp('fast', function() {
			// Animation complete.
		});
		$(".social-media-link-active").slideDown('fast', function() {
			// Animation complete.
		});		
	});
	$(document).on("mouseout",".social-media-link-active", function() {
		var id = $(this).attr("id").replace("-active","");
		$("#" + id + "-active").slideUp('fast', function() {
			// Animation complete.
		});
		$(".social-media-link").slideDown('fast', function() {
			// Animation complete.
		});		
	});	
	
	// back to top floating button
	var offset = 220;
    var duration = 500;
    $(window).scroll(function() {
        if (jQuery(this).scrollTop() > offset) {
            jQuery('.back-to-top').fadeIn(duration);
			$("#menu").removeClass("menu-regular");
			$("#menu").removeClass("animated slideInUp");
			$("#menu").addClass("menu-fixed"); 
			$("#menu").addClass("animated slideInDown");
			$(".small-logo").show();
			$(".small-contact").show();
        } else {
            jQuery('.back-to-top').fadeOut(duration);
			$("#menu").removeClass("animated slideInDown");
			$("#menu").removeClass("menu-fixed");
			$("#menu").addClass("menu-regular");
			$("#menu").addClass("animated slideInUp");
			$(".small-logo").hide();
			$(".small-contact").hide();
        }
    });    
    $('.back-to-top').click(function(event) {
        event.preventDefault();
        jQuery('html, body').animate({scrollTop: 0}, duration);
        return false;
    });	
	
	// download button 
	$(".download").append("<img src='" + scriptURL + "images/action-images/download-icon.png' alt='download' title='Download' class='download-icon' />");
	
	// dynamic phone navigation
	$("a#dynamic-phone-menu").click( function() {
		$("#phone-logo").toggleClass("faded");
		$("#content").toggleClass("faded");
		$("#footer-container").toggleClass("faded");
		$("#phone-nav-overlay").slideToggle("fast");
	});	
	
	// set left column height
	var colHeight = $("#main-container").outerHeight();
	$("#main-lcol").css("height",colHeight);	
	$("#main-rcol").css("min-height",colHeight);
	
	$(window).resize(function() {
		var colHeight = $("#main-container").outerHeight();
		$("#main-lcol").css("height",colHeight);	
		$("#main-rcol").css("min-height",colHeight);
	});
	
	// UPPERCASE FOR POSTAL CODES & VALIDITY
	$("input[name='postal_codex']").on("keyup", function(e) {
		e.preventDefault();		
		if ($(this).val().length == 3) {
			var newVal = $(this).val() + " ";
			$(this).val(newVal);
		} else {
			$(this).val($(this).val().toUpperCase());
		}		
		if ($(this).val().length == 7) {
			// format is correct...
			$(this).css({"background-color":"lightgreen"});
		}		
	});	
	
	// FORMAT PHONE NUMBERS
	$("input[name='phonex'], input[name='phone'], input[name='cellPhoneNumber']").on("keydown", function(event) {
		event.preventDefault();	
		var e = event || evt; // for trans-browser compatibility
		//var c = String.fromCharCode(e.which) || String.fromCharCode(e.keyCode);
		var charCode = event.which || event.keyCode;
		var c = String.fromCharCode(charCode);  // works for IE and real browsers	
		if (charCode == 8) {
			// do nothing - allow deletion
			var newVal = $(this).val();
			newVal = newVal.substring(0,newVal.length - 1);
			$(this).val(newVal);
			return true;
		} else {			
			if ((charCode > 47 && charCode < 58) || charCode == 40 || charCode == 41 || charCode == 9 || charCode == 32) {
				//alert(charCode + " = " + c);	
				if ($(this).val().length <= 11) {					
					if ($(this).val().length == 2) {
						var newVal = $(this).val() + c + "-";
						$(this).val(newVal);
					} else if ($(this).val().length == 6) {
						var newVal = $(this).val() + c + "-";
						$(this).val(newVal);
					} else {
						var newVal = $(this).val() + c;
						$(this).val(newVal);
					}
					//$(this).val($(this).val() + c);
					if ($(this).val().length == 12) {
						// format is correct...
						$(this).css({"border":"1px solid #49E20E"});
					}				
					return true;			
				} else {			
					return false;
				}
			} else {		
				return false;
			}
		}
	});	
	
	// faqs
	$('.faqs-show-answer').click( function(e) {
		e.preventDefault();
		//$('.faqs-answer').hide();
		var currentID = $(this).attr('id');
		$('#answer-' + currentID).slideToggle('fast', function() {
			// Animation complete.
		});
	});	
	
	// SEND MAP TO PHONE
	$("#sendMapToPhone").submit(function(e){
		e.preventDefault(); 
		// show processing message
		$("#message-send-to-phone").fadeIn("slow").html("<img src='" + scriptURL + "images/action-images/ajax-loader.gif' alt='loading' class='loading-icon' />&nbsp;The map link is being sent to your phone...");
		$.post(scriptURL + "process-send-map.php", $("#sendMapToPhone").serialize(),
		function(data){
			setTimeout(function(){
				if (data.error == "false") {
					$("#message-send-to-phone").html("<span class='success'>The map link was sent via SMS text to your phone.</span>");
					setTimeout(function(){
						// simple 4 second delay before reactivating the form.
						$("#message-send-to-phone").fadeOut('slow');
						$("input[name='cellPhoneNumber']").val("").css("border","1px solid #939598");
						$("select[name='cellPhoneCarrier']").val("0");
					}, 2000);
				} else {
					$("#message-send-to-phone").html("<span class='error'>" + data.errorMessage + "</span>");
				}
			}, 2000);											
		}, "json");
	});		
	
	// LIVE VALIDATION OF EMAIL
	// live check of email address using REGEX (will also validate with PHP) and user confirmation by e-mail
	function isValidEmailAddress(emailAddress) {
		var pattern = new RegExp(/^(("[\w-+\s]+")|([\w-+]+(?:\.[\w-+]+)*)|("[\w-+\s]+")([\w-+]+(?:\.[\w-+]+)*))(@((?:[\w-+]+\.)*\w[\w-+]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$)|(@\[?((25[0-5]\.|2[0-4][\d]\.|1[\d]{2}\.|[\d]{1,2}\.))((25[0-5]|2[0-4][\d]|1[\d]{2}|[\d]{1,2})\.){2}(25[0-5]|2[0-4][\d]|1[\d]{2}|[\d]{1,2})\]?$)/i);
		return pattern.test(emailAddress);
	};	
	$("input[name='emailx'], input[name='email']").on("keydown", function(e) {		
		if(($(this).val().length > 200 || e.keyCode == "32") && e.keyCode != 8 ) {
			e.preventDefault();
			emailValid = 'false';			
			return false;				
		} else {
			$("input[name='emailx'], input[name='email']").on("keyup", function() {
				if (!isValidEmailAddress($(this).val()) && $(this).val().length >= 0) {
					emailValid = 'false';			
					$(this).css({"border":"1px solid #ff0000"});					
				} else {
					emailValid = 'true';		
					$(this).css({"border":"1px solid #49E20E"});
				}
			});
		}
	});
	$("input[name='firstnamex']").css("color","#888888");
	$("input[name='lastnamex']").css("color","#888888");
	$("input[name='emailx']").css("color","#888888");
	$("input[name='phonex']").css("color","#888888");
	$("textarea[name='messagex']").css("color","#888888");
	
	$("input[name='firstnamex']").focus(function() { if($(this).val() == 'FIRST NAME') { $(this).css("color","#888888"); $(this).val(""); } });	
	$("input[name='firstnamex']").blur(function() { if($(this).val() == '') { $(this).css("color","#888888"); $(this).val("FIRST NAME"); } });	
	$("input[name='lastnamex']").focus(function() { if($(this).val() == 'LAST NAME') { $(this).css("color","#888888"); $(this).val(""); } });	
	$("input[name='lastnamex']").blur(function() { if($(this).val() == '') { $(this).css("color","#888888"); $(this).val("LAST NAME"); } });
	$("input[name='emailx']").focus(function() { if($(this).val() == 'E-MAIL') { $(this).css("color","#888888"); $(this).val(""); } });	
	$("input[name='emailx']").blur(function() { if($(this).val() == '') { $(this).css("color","#888888"); $(this).val("E-MAIL"); } });
	$("input[name='phonex']").focus(function() { if($(this).val() == 'PHONE NUMBER') { $(this).css("color","#888888"); $(this).val(""); } });	
	$("input[name='phonex']").blur(function() { if($(this).val() == '') { $(this).css("color","#888888"); $(this).val("PHONE NUMBER"); } });
	$("textarea[name='messagex']").focus(function() { if($(this).val() == 'MESSAGE') { $(this).css("color","#888888"); $(this).val(""); } });	
	$("textarea[name='messagex']").blur(function() { if($(this).val() == '') { $(this).css("color","#888888"); $(this).val("MESSAGE"); } });
	
	$("#contactFrm").submit(function(e){
		e.preventDefault();  
		
		var frmError = 'false';
		if (emailValid == "false") {
			$("input[name='emailx']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';			
		}	
		if ($("input[name='firstnamex']").val() == '' || $("input[name='firstnamex']").val() == 'FIRST NAME') {
			$("input[name='firstnamex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}
		if ($("input[name='lastnamex']").val() == '' || $("input[name='lastnamex']").val() == 'LAST NAME') {
			$("input[name='lastnamex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}	
		if ($("input[name='phonex']").val() == '' || $("input[name='phonex']").val() == 'PHONE NUMBER' || $("input[name='phonex']").val().length < '12') {
			$("input[name='phonex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}	
		if ($("textarea[name='messagex']").val() == '' || $("textarea[name='messagex']").val() == 'MESSAGE') {
			$("textarea[name='messagex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}
		
		// process form if there are no errors
		if (frmError == 'false') {
			$("#SubmitBtn").attr("disabled", true);
			// show processing message
			$("#message_post").fadeIn("slow").html("<img src='" + scriptURL + "images/action-images/ajax-loader.gif' alt='loading' class='loading-icon' />&nbsp;Processing form...");		
			$.post(scriptURL + "process-form.php", $(this).serialize() + "&location_id=" + location_id,		
			function(data) {
				if(data.error == "false") {
					$(this).css("opacity","1.0").attr("disabled", true);
					setTimeout(function () {
						$("#message_post").html("<span class='success'>Thank you, your message has been sent.</span>");
						setTimeout(function () {
							$("input[name='firstnamex']").css("color","#888888").val("FIRST NAME");
							$("input[name='lastnamex']").css("color","#888888").val("LAST NAME");
							$("input[name='emailx']").css("color","#888888").val("E-MAIL");
							$("input[name='phonex']").css("color","#888888").val("PHONE NUMBER");
							$("textarea[name='messagex']").css("color","#888888").val("MESSAGE");
							$("#message_post").fadeOut("slow");
							$("#SubmitBtn").attr("disabled", false);
							$(this).css("opacity","1.0").attr("disabled", false);
						}, 2000);		
						$("#overlay").fadeOut();						
					}, 4000);	
				} else {
					setTimeout(function () {
					$("#SubmitBtn").attr("disabled", false);
						$("#message_post").html("<span class='error'>" + data.errorMessage + "</span>");
					}, 2000);	
				}
			}, "json");
		}
	});	

	$("#inlineContactFrm").submit(function(e){
		e.preventDefault(); 

		var frmError = 'false';
		if (emailValid == "false") {
			$("input[name='emailx']").css("border","1px solid #ff0000");
			frmError = 'true';			
		}	
		if ($("input[name='firstnamex']").val() == '' || $("input[name='firstnamex']").val() == 'FIRST NAME') {
			$("input[name='firstnamex']").css("border","1px solid #ff0000");
			frmError = 'true';
		}
		if ($("input[name='lastnamex']").val() == '' || $("input[name='lastnamex']").val() == 'LAST NAME') {
			$("input[name='lastnamex']").css("border","1px solid #ff0000");
			frmError = 'true';
		}	
		if ($("input[name='phonex']").val() == '' || $("input[name='phonex']").val() == 'PHONE NUMBER' || $("input[name='phonex']").val().length < '12') {
			$("input[name='phonex']").css("border","1px solid #ff0000");
			frmError = 'true';
		}	
		if ($("textarea[name='messagex']").val() == '' || $("textarea[name='messagex']").val() == 'MESSAGE') {
			$("textarea[name='messagex']").css("border","1px solid #ff0000");
			frmError = 'true';
		}	
		if ($("select[name='location_id']").val() == '' || $("select[name='location_id']").val() == 'MESSAGE') {
			$("select[name='location_id']").css("border","1px solid #ff0000");
			frmError = 'true';
		}

		// process form if there are no errors
		if (frmError == 'false') {
			// show processing message
			$("#message_post").fadeIn("slow").html("<img src='" + scriptURL + "images/action-images/ajax-loader.gif' alt='loading' class='loading-icon' />&nbsp;Processing form...");
			$.post(scriptURL + "process-homepage-form.php", $(this).serialize(),		
			function(data) {
				if(data.error == "false") {
					$(this).css("opacity","1.0").attr("disabled", true);
					setTimeout(function () {
						$("#message_post").html("<span class='success'>Thank you, your message has been sent.</span>");
						setTimeout(function () {
							$("input[name='firstnamex']").css("color","#888888").val("FIRST NAME");
							$("input[name='lastnamex']").css("color","#888888").val("LAST NAME");
							$("input[name='emailx']").css("color","#888888").val("E-MAIL");
							$("input[name='phonex']").css("color","#888888").val("PHONE NUMBER");
							$("textarea[name='messagex']").css("color","#888888").val("MESSAGE");
							$("#message_post").fadeOut("slow");
							$("#SubmitBtn").attr("disabled", false);
							$(this).css("opacity","1.0").attr("disabled", false);
						}, 2000);		
						$("#overlay").fadeOut();						
					}, 4000);	
				} else {
					setTimeout(function () {
					$("#SubmitBtn").attr("disabled", false);
						$("#message_post").html("<span class='error'>" + data.errorMessage + "</span>");
					}, 2000);	
				}
			}, "json");
		} else {
			$("#message_post").fadeIn("slow").html("<span style='color: #ff0000;'>Please complete all fields.</span>");			
		}
	});						
	
	$("#contactFrmLocation").submit(function(e){
		e.preventDefault();  
		
		var frmError = 'false';
		if (emailValid == "false") {
			$("input[name='emailx']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';			
		}	
		if ($("input[name='firstnamex']").val() == '' || $("input[name='firstnamex']").val() == 'FIRST NAME') {
			$("input[name='firstnamex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}
		if ($("input[name='lastnamex']").val() == '' || $("input[name='lastnamex']").val() == 'LAST NAME') {
			$("input[name='lastnamex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}	
		if ($("input[name='phonex']").val() == '' || $("input[name='phonex']").val() == 'PHONE NUMBER' || $("input[name='phonex']").val().length < '12') {
			$("input[name='phonex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}	
		if ($("textarea[name='messagex']").val() == '' || $("textarea[name='messagex']").val() == 'MESSAGE') {
			$("textarea[name='messagex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}
		// frmError = 'false'
		// process form if there are no errors
		if (frmError == 'false') {
			$("#SubmitBtn").attr("disabled", true);
			// show processing message
			$("#message_post").fadeIn("slow").html("<img src='" + scriptURL + "images/action-images/ajax-loader.gif' alt='loading' class='loading-icon' />&nbsp;Processing form...");		
			$.post(scriptURL + "process-form.php", $(this).serialize(),		
			function(data) {
				if(data.error == "false") {
					$(this).css("opacity","1.0").attr("disabled", true);
					setTimeout(function () {
						$("#message_post").html("<span class='success'>Thank you, your message has been sent.</span>");
						setTimeout(function () {
							$("input[name='firstnamex']").css("color","#888888").val("FIRST NAME");
							$("input[name='lastnamex']").css("color","#888888").val("LAST NAME");
							$("input[name='emailx']").css("color","#888888").val("E-MAIL");
							$("input[name='phonex']").css("color","#888888").val("PHONE NUMBER");
							$("textarea[name='messagex']").css("color","#888888").val("MESSAGE");
							$("#message_post").fadeOut("slow");
							$("#SubmitBtn").attr("disabled", false);
							$(this).css("opacity","1.0").attr("disabled", false);
						}, 2000);		
						$("#overlay").fadeOut();						
					}, 4000);	
				} else {
					setTimeout(function () {
					$("#SubmitBtn").attr("disabled", false);
						$("#message_post").html("<span class='error'>" + data.errorMessage + "</span>");
					}, 2000);	
				}
			}, "json");
		}
	});	
	
	$("#contactFrmGeneral").submit(function(e){
		e.preventDefault();  
		
		var frmError = 'false';
		if (emailValid == "false") {
			$("input[name='emailx']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';			
		}	
		if ($("input[name='firstnamex']").val() == '' || $("input[name='firstnamex']").val() == 'FIRST NAME') {
			$("input[name='firstnamex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}
		if ($("input[name='lastnamex']").val() == '' || $("input[name='lastnamex']").val() == 'LAST NAME') {
			$("input[name='lastnamex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}	
		if ($("input[name='phonex']").val() == '' || $("input[name='phonex']").val() == 'PHONE NUMBER' || $("input[name='phonex']").val().length < '12') {
			$("input[name='phonex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}	
		if ($("textarea[name='messagex']").val() == '' || $("textarea[name='messagex']").val() == 'MESSAGE') {
			$("textarea[name='messagex']").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}
		
		// process form if there are no errors
		if (frmError == 'false') {
			$("#SubmitBtn").attr("disabled", true);
			// show processing message
			$("#message_post").fadeIn("slow").html("<img src='" + scriptURL + "images/action-images/ajax-loader.gif' alt='loading' class='loading-icon' />&nbsp;Processing form...");		
			$.post(scriptURL + "process-general-form.php", $(this).serialize(),		
			function(data) {
				if(data.error == "false") {
					$(this).css("opacity","1.0").attr("disabled", true);
					setTimeout(function () {
						$("#message_post").html("<span class='success'>Thank you, your message has been sent.</span>");
						setTimeout(function () {
							$("input[name='firstnamex']").css("color","#888888").val("FIRST NAME");
							$("input[name='lastnamex']").css("color","#888888").val("LAST NAME");
							$("input[name='emailx']").css("color","#888888").val("E-MAIL");
							$("input[name='phonex']").css("color","#888888").val("PHONE NUMBER");
							$("textarea[name='messagex']").css("color","#888888").val("MESSAGE");
							$("#message_post").fadeOut("slow");
							$("#SubmitBtn").attr("disabled", false);
							$(this).css("opacity","1.0").attr("disabled", false);
						}, 2000);		
						$("#overlay").fadeOut();						
					}, 4000);	
				} else {
					setTimeout(function () {
					$("#SubmitBtn").attr("disabled", false);
						$("#message_post").html("<span class='error'>" + data.errorMessage + "</span>");
					}, 2000);	
				}
			}, "json");
		}
	});
	
/*
	// request an appointment
	$('#frmName').css("color","#ffffff");
	$('#frmEmail').css("color","#ffffff");
	$('#frmPhone').css("color","#ffffff");
	
	$('#frmName').focus(function() {
		if($('#frmName').val() == 'NAME') {
			$('#frmName').css("color","#ffffff");
			this.value = "";
		}
	});
	$('#frmName').blur(function() {
		if($('#frmName').val() == '') {
			$('#frmName').css("color","#ffffff");
			this.value = "NAME";
		}
	});
	$('#frmEmail').focus(function() {
		if($('#frmEmail').val() == 'EMAIL') {
			$('#frmEmail').css("color","#ffffff");
			this.value = "";
		}
	});
	$('#frmEmail').blur(function() {
		if($('#frmEmail').val() == '') {
			$('#frmEmail').css("color","#ffffff");
			this.value = "EMAIL";
		}
	});
	$('#frmPhone').focus(function() {
		if($('#frmPhone').val() == 'PHONE') {
			$('#frmPhone').css("color","#ffffff");
			this.value = "";
		}
	});
	$('#frmPhone').blur(function() {
		if($('#frmPhone').val() == '') {
			$('#frmPhone').css("color","#ffffff");
			this.value = "PHONE";
		}
	});	
	$("#request-appointment").submit(function(e) {
		e.preventDefault();  
		var tempName = $("#frmName").val();
		var tempPhone = $("#frmPhone").val();
		var tempEmail = $("#frmEmail").val();
		var tempMessage = $("#frmMessage").val();
		var frmError = 'false';
		if(tempName == '' || tempName == 'NAME') {
			$("#frmName").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}
		if(tempEmail == '' || tempEmail == 'EMAIL') {
			$("#frmEmail").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}
		if(tempPhone == '' || tempPhone == 'PHONE') {
			$("#frmPhone").effect('shake', {times:3, distance:3}, 100);
			frmError = 'true';
		}
		if (frmError == 'false') {	
			jQuery('html, body').animate({scrollTop: 0}, duration);
		
			// show processing message
			$("#message_post_request").fadeIn("slow").html("<img src='" + scriptURL + "images/action-images/ajax-loader.gif' alt='loading' class='loading-icon' />&nbsp;Processing form...");
			$.post(scriptURL + "process-request-form.php", $("#request-appointment").serialize(),
			function(data){
				setTimeout(function(){
					if (data.error == "false") {
						$("#message_post_request").html("<li class='success'>Thank you, your e-mail was sent. We will be in touch with you shortly.</li>");
						setTimeout(function(){
							// simple 4 second delay before reactivating the form.
							$("#message_post_request").fadeOut('slow');
							$("form#request-appointment").css("opacity","1.0").attr("disabled", false);
							$("#submitRequestBtn").attr("disabled", false);
							$("#frmName").val('NAME');
							$("#frmPhone").val('PHONE');
							$("#frmEmail").val('EMAIL');
							$("#frmMessage").val('');
							$('#frmName').css("color","#999999");
							$('#frmEmail').css("color","#999999");
							$('#frmPhone').css("color","#999999");
						}, 2000);
					} else {
						$("#message_post_request").html("<li class='error'>" + data.errorMessage + "</li>");
					}
				}, 2000);													
			}, "json");
		}
	});	
*/
});