<?php

/**
 * The sub-class that manages the clinic custom post type
 *
 * @link       https://aheadoftheweb.com/
 * @since      1.0.0
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 */

/**
 * The sub-class that manages the clinic custom post type
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 * @author     Graeme <Gibson>
 */
class Aow_Hub_Node_CPT_City extends Aow_Hub_Node_CPT {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Parent plugin class
	 *
	 * @var class
	 * @since  1.1.0
	 */
	protected $plugin = null;

	/**
	 * ID, Text Domain
	 *
	 * @var string
	 * @since  1.2.0
	 */
	protected $ID = 'clinic-city';
	
	public $posttype = 'clinic-city';

	public $singular = 'City';
	
	public $key = 'cityid';
	
	//?get_cities=get_cities&custom_brand=';

	/**
	 * Menu Slug
	 *
	 * @var string
	 * @since  1.2.0
	 *
	public $menuSlug = 'city-settings';
	
	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin ) {
		$this->admin = $plugin;
		parent::__construct(
			array( __( 'Clinic City', $this->ID ), __( 'Clinic Cities', $this->ID ), $this->ID ),
			array( 'hierarchical'			=>true,
				  	'supports' => array( 'title', 'editor', 'excerpt', 'thumbnail', 'page-attributes' ),
				   //'has_archive'	=> false,
				   'rewrite'	  => array(
					  'slug'                  => 'in',
					  'with_front'            => true,
					  'pages'                 => false,
					  'feeds'                 => false,
		  			),
					'show_in_nav_menus'		=>true,
		
					
			 )
		);
		
	}
	
	public function get_meta( $cip ){
		$meta_fields = array(
			'cip'		=> json_encode( $cip ),
			'cityid'	=> $cip->id,
			'prov_name'	=> $cip->prov_name,
			'prov_id'	=> $cip->prov_id,
		);
		return $meta_fields;
	}

}
?>