<?php
// Shortcode for new business info plugin
// Add Shortcode
function aow_get_clinic_info( $atts ) {

	global $admin;
	
	// Attributes
	$atts = shortcode_atts(
		array(
			'info' 		=> 'FALSE',
			'id'		=> FALSE,
			'height'	=> 400,
			'width'		=> 800,
			'length'	=> 'short',
			
		),
		$atts
	);

	if( $atts[ 'info' ] ){
		$r = $atts[ 'info' ];
	}else{
		return false;
	}
	global $aow_get_clinic_info_id;
	$aow_get_clinic_info_id = $atts[ 'id' ];
	
	$info = '';

	if( $r == 'clinic-name' ){
		$info = $admin->helper->aow_get_option( 'clinic_name' );
		return $info;
	}
	if( $r == 'telephone' ){
		$clinic_phone_raw = '+1' . $admin->helper->aow_get_option( 'telephone' );
		if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $clinic_phone_raw,  $matches ) ){
			$info = '(' . $matches[1] . ') ' .$matches[2] . '-' . $matches[3];
		}
		return $info;
	}
	if( $r == 'telephone-raw' ){
		$info = '+1' . $admin->helper->aow_get_option( 'telephone' );
		return $info;
	}
	if( $r == 'telephone-link' ){
		$clinic_phone_raw = '+1' . $admin->helper->aow_get_option( 'telephone' );
		if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $clinic_phone_raw,  $matches ) ){
			$clinic_phone_formatted = '(' . $matches[1] . ') ' .$matches[2] . '-' . $matches[3];
		}else{
			$clinic_phone_formatted = $clinic_phone_raw;
		}
		$info = '<a href="tel:' . $clinic_phone_raw . '">' . $clinic_phone_formatted . '</a>';
		
		return $info;
	}
	if( $r == 'fax' ){
		$clinic_phone_raw = '+1' . $admin->helper->aow_get_option( 'fax' );
		if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $clinic_phone_raw,  $matches ) ){
			$info = '(' . $matches[1] . ') ' .$matches[2] . '-' . $matches[3];
		}
		return $info;
	}
	if( $r == 'fax-raw' ){
		$info = '+1' . $admin->helper->aow_get_option( 'fax' );
		return $info;
	}
	if( $r == 'fax-link' ){
		$clinic_fax_raw = '+1' . $admin->helper->aow_get_option( 'fax' );
		if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $clinic_fax_raw,  $matches ) ){
			$clinic_fax_formatted = '(' . $matches[1] . ') ' .$matches[2] . '-' . $matches[3];
		}else{
			$clinic_fax_formatted = $clinic_fax_raw;
		}
		$info = '<a href="tel:' . $clinic_fax_raw . '">' . $clinic_fax_formatted . '</a>';
		return $info;
	}
	if( $r == 'email' ){
		$info = $admin->helper->aow_get_option( 'email' );
		return $info;
	}
	if( $r == 'email-link' ){
		$aow_email = $admin->helper->aow_get_option( 'email' );
		$info = '<a href="mailto:' . $aow_email . '">' . $aow_email . '</a>';
		return $info;
	}
	if( $r == 'websiteurl' ){
		$info = $admin->helper->aow_get_option( 'websiteurl' );
		return $info;
	}
	if( $r == 'website-link' ){
		$url = $admin->helper->aow_get_option( 'websiteurl' );
		$city = $admin->helper->aow_get_option( 'city' );
		$clinic_name = $admin->helper->aow_get_option( 'clinic_name' );
		$info = "<a href='$url' title='Website for $city dentist $clinic_name'>$url</a>";
		return $info;
	}
	if( $r == 'profileurl' ){
		$info = $admin->helper->aow_get_option( 'profileurl' );
		return $info;
	}
	if( $r == 'address' ){
		$address_street = $admin->helper->aow_get_option( 'street' );
		$address_city = $admin->helper->aow_get_option( 'city' );
		$address_province = $admin->helper->abbreviate_province( $admin->helper->aow_get_option( 'province' ) );
		$address_country = $admin->helper->aow_get_option( 'country' );
		$address_postal = $admin->helper->format_postal( $admin->helper->aow_get_option( 'postal_code' ) );
		$info .= $address_street;
		if( isset( $address_unit ) && $address_unit != '' ){
			$info .= ', ' . $address_unit;
		}
		$info .= '<br />' . $address_city . ' ' . $address_province;
		$info .= '<br />' . $address_country . ' ' . $address_postal;
		return $info;
	}
	if( $r == 'address-street' ){
		$info = $admin->helper->aow_get_option( 'street' );
		return $info;
	}
	if( $r == 'address-city' ){
		$info = $admin->helper->aow_get_option( 'city' );
		return $info;
	}
	if( $r == 'address-province' ){
		$info = $admin->helper->abbreviate_province ( $admin->helper->aow_get_option( 'province' ) );
		return $info;
	}
	if( $r == 'address-province-full' ){
		$info = $admin->helper->aow_get_option( 'province' );
		return $info;
	}
	if( $r == 'address-country' ){
		$info = $admin->helper->aow_get_option( 'country' );
		return $info;
	}
	if( $r == 'address-postal' ){
		if( $admin->helper->aow_get_option( 'postal_code', 'false' ) == 'false' ){
			$info = 'No business postal code set';
		}else{
			$info = $admin->helper->format_postal( $admin->helper->aow_get_option( 'postal_code' ) );
		}
		return $info;
	}
	if( $r == 'logo' ){
		$info = $admin->helper->aow_get_option( 'logo' );
		if( $info && $info != '' ){
			$info = '<img src="' . $info . '">';
		}
		return $info;
	}
	if( $r == 'image' ){
		$info = $admin->helper->aow_get_option( 'logo' );
		return $info;
	}
	if( $r == 'description' ){
		$info = $admin->helper->aow_get_option( 'description' );
		return $info;
	}
	if( $r == 'facebook' ){
		$info = $admin->helper->aow_get_option( 'facebookurl' );
		return $info;
	}
	if( $r == 'yelp' ){
		$info = $admin->helper->aow_get_option( 'yelp_reviews_id' );
		return $info;
	}
	if( $r == 'latitude' ){
		$info = $admin->helper->aow_get_option( 'latitude' );
		return $info;
	}
	if( $r == 'longitude' ){
		$info = $admin->helper->aow_get_option( 'longitude' );
		return $info;
	}
	if( $r == 'map' ){
		$google_api = get_theme_mod( 'aow_google_api' );
		$url_safe_clinic_name = urlencode( $admin->helper->aow_get_option( 'clinic_name' ) );
		$aow_google_id = $admin->helper->aow_get_option( 'map' );
		$info = '<iframe height="' . $atts[ 'height' ] . '" width="' . $atts[ 'width' ] . '" src="https://www.google.com/maps/embed/v1/place?key=' . $google_api . '&q=place_id:' . $aow_google_id . '"></iframe>';
		return $info;
	}
	if( $r == 'tour' ){
		$src = $admin->helper->aow_get_option( 'virtual_tour' );
		$height = $atts[ 'height' ];
		$width = $atts[ 'width' ];
		if( $src ){ 
			$info = "<iframe src='$src' width='$width' height='$height' frameborder='0' style='border:0;' allowfullscreen='' aria-hidden='false' tabindex='0'></iframe>";
		}else{
			$info = '';
		}
		return $info;
	}
	if( $r == 'tour-src' ){
		$info = $admin->helper->aow_get_option( 'virtual_tour' );
		return $info;
	}
	if( $r == 'mon-open' ){
		$info = $admin->helper->aow_get_option( 'mon_open' );
		return $info;
	}
	if( $r == 'mon-closed' ){
		$info = $admin->helper->aow_get_option( 'mon_closed' );
		return $info;
	}
	if( $r == 'mon-msg' ){
		$info = $admin->helper->aow_get_option( 'mon_msg' );
		return $info;
	}
	if( $r == 'tue-open' ){
		$info = $admin->helper->aow_get_option( 'tue_open' );
		return $info;
	}
	if( $r == 'tue-closed' ){
		$info = $admin->helper->aow_get_option( 'tue_closed' );
		return $info;
	}
	if( $r == 'tue-msg' ){
		$info = $admin->helper->aow_get_option( 'tue_msg' );
		return $info;
	}
	if( $r == 'wed-open' ){
		$info = $admin->helper->aow_get_option( 'wed_open' );
		return $info;
	}
	if( $r == 'wed-closed' ){
		$info = $admin->helper->aow_get_option( 'wed_closed' );
		return $info;
	}
	if( $r == 'wed-msg' ){
		$info = $admin->helper->aow_get_option( 'wed_msg' );
		return $info;
	}
	if( $r == 'thu-open' ){
		$info = $admin->helper->aow_get_option( 'thu_open' );
		return $info;
	}
	if( $r == 'thu-closed' ){
		$info = $admin->helper->aow_get_option( 'thu_closed' );
		return $info;
	}
	if( $r == 'thu-msg' ){
		$info = $admin->helper->aow_get_option( 'thu_msg' );
		return $info;
	}
	if( $r == 'fri-open' ){
		$info = $admin->helper->aow_get_option( 'fri_open' );
		return $info;
	}
	if( $r == 'fri-closed' ){
		$info = $admin->helper->aow_get_option( 'fri_closed' );
		return $info;
	}
	if( $r == 'fri-msg' ){
		$info = $admin->helper->aow_get_option( 'fri_msg' );
		return $info;
	}
	if( $r == 'sat-open' ){
		$info = $admin->helper->aow_get_option( 'sat_open' );
		return $info;
	}
	if( $r == 'sat-closed' ){
		$info = $admin->helper->aow_get_option( 'sat_closed' );
		return $info;
	}
	if( $r == 'sat-msg' ){
		$info = $admin->helper->aow_get_option( 'sat_msg' );
		return $info;
	}
	if( $r == 'sun-open' ){
		$info = $admin->helper->aow_get_option( 'sun_open' );
		return $info;
	}
	if( $r == 'sun-closed' ){
		$info = $admin->helper->aow_get_option( 'sun_closed' );
		return $info;
	}
	if( $r == 'sun-msg' ){
		$info = $admin->helper->aow_get_option( 'sun_msg' );
		return $info;
	}
	
	if( $r == 'promo' ){
		$promo_array = $admin->helper->get_promo_array();
		$title = ( $promo_array[ 'title' ] ) ? $promo_array[ 'title' ] : '123Dentist Promotions';
	  	$content = ( $promo_array[ 'content' ] ) ? $promo_array[ 'content' ] : 'There are no current promotions.';
		$promo = '<div class="promo_shortcode">';
		$promo .= '<h3>' . $title . '</h3>';
		$promo .= '<div>' . $content . '</div>';
		$promo .= '</div>';

		return $promo;
		
	}
	
	if( $r == 'hours' ){

		if( is_array($atts) && $atts['length'] == 'short'){
			$daylength = 2;	
		}else{
			$daylength = 1;
		}

		$hours_array = $admin->helper->get_hours_array();
		$hours = '<div class="hours_shortcode">';
		$hours .= $admin->helper->populate_aow_hub_node_hours_list( $hours_array, $daylength);
		$hours .= '</div>';

		return $hours;

	}
	if( $r == 'open-now' ){
		
	}
	if( $r == 'open-now-with-hours' ){
		$options_array = array(
			'ampm' 				=> $admin->get_option("ampmcase"),
			'ampmseparator' 	=> $admin->get_option("ampmseparator"),
			'trailing' 			=> $admin->get_option("trailingzero"),
			'separator' 		=> $admin->get_option("separator"),
		);
		// Get current day formatted as: Sunday through Saturday
		$current_day = current_time( 'l' );
		$cur_day = substr( strtolower( $current_day  ), 0, 3 );
	
		// Build day variables for checking customizer
		$dayopen = $cur_day . '_open';
		$dayclosed = $cur_day . '_closed';
		
		$is_open = $admin->helper->aow_is_open_now();
		if( $is_open ){
			$info = 'OPEN NOW ';
		}else{
			$info = 'CLOSED ';
		}
		// Get data from customizer
		$opentime = $admin->helper->aow_get_option( $dayopen );
		$closedtime = $admin->helper->aow_get_option( $dayclosed );
		if( $opentime == 'closed' ){
			$info .= strtoupper( $current_day ) . 'S';
		}else{
			$info .= '(' . $admin->helper->aow_hub_node_time_return($opentime, 0, $options_array[ 'ampm' ], $options_array[ 'trailing' ], $options_array[ 'ampmseparator' ], 'false' ) . ' - ' . $admin->helper->aow_hub_node_time_return($closedtime, 0, $options_array[ 'ampm' ], $options_array[ 'trailing' ], $options_array[ 'ampmseparator' ], 'false' ) . ')';
		}
		
		return $info;
	}
	if( $r == 'todays-open-hours' ){
		$options_array = array(
			'ampm' 				=> $admin->get_option("ampmcase"),
			'ampmseparator' 	=> $admin->get_option("ampmseparator"),
			'trailing' 			=> $admin->get_option("trailingzero"),
			'separator' 		=> $admin->get_option("separator"),
		);
		// Get current day formatted as: Sunday through Saturday
		$cur_day = substr( strtolower( current_time( 'l' ) ), 0, 3 );
	
		// Build day variables for checking customizer
		$dayopen = $cur_day . '_open';
		
		// Get data from customizer
		$opentime = $admin->helper->aow_get_option( $dayopen );
		
		$info = $admin->helper->aow_hub_node_time_return($opentime, 0, $options_array[ 'ampm' ], $options_array[ 'trailing' ], $options_array[ 'ampmseparator' ], 'false' );

		
		return $info;
	}
	if( $r == 'todays-closing-hours' ){
		$options_array = array(
			'ampm' 				=> $admin->get_option("ampmcase"),
			'ampmseparator' 	=> $admin->get_option("ampmseparator"),
			'trailing' 			=> $admin->get_option("trailingzero"),
			'separator' 		=> $admin->get_option("separator"),
		);
		// Get current day formatted as: Sunday through Saturday
		$cur_day = substr( strtolower( current_time( 'l' ) ), 0, 3 );
	
		// Build day variables for checking customizer
		$dayopen = 'aow_' . $cur_day . '_closed';
		
		// Get data from customizer
		$opentime = $admin->helper->aow_get_option( $dayopen );
		
		$info = $admin->helper->aow_hub_node_time_return($opentime, 0, $options_array[ 'ampm' ], $options_array[ 'trailing' ], $options_array[ 'ampmseparator' ], 'false' );
		
		return $info;
	}
	if( $r == 'todays-msg' ){
		// Get current day formatted as: Sunday through Saturday
		$cur_day = substr( strtolower( current_time( 'l' ) ), 0, 3 );
	
		// Build day variables for checking customizer
		$dayopen = 'aow_' . $cur_day . '_msg';
		
		// Get data from customizer
		$info = $admin->helper->aow_get_option( $dayopen );
		
		return $info;
	}
	if( $r == 'tomorrows-open-hours' ){
		$options_array = array(
			'ampm' 				=> $admin->get_option("ampmcase"),
			'ampmseparator' 	=> $admin->get_option("ampmseparator"),
			'trailing' 			=> $admin->get_option("trailingzero"),
			'separator' 		=> $admin->get_option("separator"),
		);
		// Get current day formatted as: Sunday through Saturday
		$tomorrow_date = new DateTime( 'tomorrow' );
		$tomorrow = substr( strtolower( $tomorrow_date->format( 'l' ) ), 0, 3 );
			
			//= substr( strtolower( current_time( 'l' ) ), 0, 3 );
	
		// Build day variables for checking customizer
		$dayopen = 'aow_' . $tomorrow . '_open';
		
		// Get data from customizer
		$opentime = $admin->helper->aow_get_option( $dayopen );
		
		$info = $admin->helper->aow_hub_node_time_return($opentime, 0, $options_array[ 'ampm' ], $options_array[ 'trailing' ], $options_array[ 'ampmseparator' ], 'false' );
		
		return $info;
	}
	if( $r == 'clinic-count'){
		$count = get_theme_mod( 'aow_clinic_count', 'Not set' );
		return $count;
	}
	
}
add_shortcode( 'aow_get_clinic', 'aow_get_clinic_info' );