<?php

class Aow_Hub_Node_Helper {
	
	private $admin;
	
	public function __construct( $admin ) {
	$this->admin = $admin;
	}

	function aow_get_option( $option, $custom_default = FALSE ){
			global $aow_get_clinic_info_id;
			$id = $aow_get_clinic_info_id;
			$data = '';
			if( $custom_default ){
				$default = $custom_default;
			}else{
				$default = 'Option not found: ' . $option;
			}
			if( $id ){
				if( $id == 'this' ){
					global $post;
					$data = ($post) ? get_post_meta( $post->ID, $option, TRUE ) : '';
				}else{
					$post = get_post( $id, OBJECT );
					$data = get_post_meta( $post->ID, $option, TRUE );
				}
				if( !$data ){ $data = $custom_default; }
			}else{
				$option = 'aow_' . $option;
				$data = get_theme_mod( $option, $default );
			}
			return $data;
	}
	
	function aow_is_open_now( $time = 0 ){

		// Get current day formatted as: Sunday through Saturday
		$cur_day = substr( strtolower( current_time( 'l' ) ), 0, 3 );

		// Get current time
		$cur_time = current_time( 'Gi' );

		// Build day variables for checking customizer
		$dayopen = $cur_day . '_open';
		$dayclosed = $cur_day . '_closed';

		// Check if open today
		if( $this->aow_get_option( $cur_day . '_open' ) == 'closed' ){
			$cur_status = 'yes'; 
		}else{
			$cur_status = 'no';
		}

		// Get open hours for current day
		$cur_open =	$this->aow_get_option( $dayopen );

		// Get closed hours for current day
		$cur_closing = 	$this->aow_get_option( $dayclosed );

		if( $cur_status == 'yes' ){
			return false;
		}elseif( $cur_time >= $cur_open && $cur_time <= $cur_closing ){
			if( $time == 0 ){
				return true;
			}else{
				$cur_closing_array = str_split( $cur_closing );
				if( array_key_exists( 3, $cur_closing_array ) ){
					// Time has four digits
					$cur_closing_obj = mktime( $cur_closing_array[0] . $cur_closing_array[1], $cur_closing_array[2] . $cur_closing_array[3], 0, date('n'), date('j'), date('Y') );

					$dt = new DateTime( '@' . $cur_closing_obj );

					$now = new DateTime( '@' . current_time( 'timestamp' ) );

					$diff = $now->diff( $dt );

					$minutes_until_closed = ( $diff->h * 60 ) + ( $diff->i );
					if( $time >= $minutes_until_closed){
						return true;
					}else{
						return false;
					}
				}else{
					// Time has three digits
					$cur_closing_obj = mktime( $cur_closing_array[0], $cur_closing_array[1] . $cur_closing_array[2], 0, date('n'), date('j'), date('Y') );

					$dt = new DateTime( '@' . $cur_closing_obj );

					$now = new DateTime( '@' . current_time( 'timestamp' ) );

					$diff = $now->diff( $dt );

					$minutes_until_closed = ( $diff->h * 60 ) + ( $diff->i );
					if( $time >= $minutes_until_closed){
						return true;
					}else{
						return false;
					}
				}
			}

		}else{
			if( $time == 0 ){
				return false;
			}else{
				$cur_open_array = str_split( $cur_open );
				if( array_key_exists( 3, $cur_open_array ) ){
					// Time has four digits
					$cur_open_obj = mktime( $cur_open_array[0] . $cur_open_array[1], $cur_open_array[2] . $cur_open_array[3], 0, date('n'), date('j'), date('Y') );

					$dt = new DateTime( '@' . $cur_open_obj );

					$now = new DateTime( '@' . current_time( 'timestamp' ) );

					$diff = $now->diff( $dt );

					$minutes_until_open = ( $diff->h * 60 ) + ( $diff->i );
					if( $time >= $minutes_until_open){
						return true;
					}else{
						return false;
					}
				}else{
					// Time has three digits
					$cur_open_obj = mktime( $cur_open_array[0], $cur_open_array[1] . $cur_open_array[2], 0, date('n'), date('j'), date('Y') );

					$dt = new DateTime( '@' . $cur_open_obj );

					$now = new DateTime( '@' . current_time( 'timestamp' ) );

					$diff = $now->diff( $dt );

					$minutes_until_open= ( $diff->h * 60 ) + ( $diff->i );
					if( $time >= $minutes_until_open){
						return true;
					}else{
						return false;
					}
				}	
			}
		}	
	}

	function abbreviate_province( $province ){
		$ap = '';
		$province = $province;
		switch( $province ){
			case 'Alberta':
				$ap = 'AB';
				break;
			case 'British Columbia':
				$ap = 'BC';
				break;
			case 'Manitoba':
				$ap = 'MB';
				break;
			case 'New Brunswick':
				$ap = 'NB';
				break;
			case 'Newfoundland and Labrador':
				$ap = 'NL';
				break;
			case 'Northwest Territories':
				$ap = 'NT';
				break;
			case 'Nova Scotia':
				$ap = 'NS';
				break;
			case 'Nunavut':
				$ap = 'NU';
				break;
			case 'Ontario':
				$ap = 'ON';
				break;
			case 'Prince Edward Island':
				$ap = 'PE';
				break;
			case 'Quebec':
				$ap = 'QC';
				break;
			case 'Saskatchewan':
				$ap = 'SK';
				break;
			case 'Yukon':
				$ap = 'YT';
				break;
		}
		return $ap;
	}

	function format_postal( $postal ){
		$formatted_postal = substr( $postal, 0, 3 ) . ' ' . substr( $postal, 3, 3 );
		return $formatted_postal;
	}

	function get_promo_array(){
		$title = $this->aow_get_option( 'promotion_title' );
		$content = $this->aow_get_option( 'promotion_content' );
		$promo_array = array(
			'title'		=> $title,
			'content'	=> $content,
		);
		return $promo_array;
	}
	
	
	function get_hours_array(){

		if( $this->aow_get_option( 'mon_open', 'closed' ) == 'closed' ){
				$monday_is_open = 1;
		}else{
			$monday_is_open = 0;
		}
			$monday_array = array(
				$this->remove_leading_zero( $this->aow_get_option( 'mon_open' ) ),
				$this->remove_leading_zero( $this->aow_get_option( 'mon_closed' ) ),
				$monday_is_open,
				$this->aow_get_option( 'mon_msg' )
			);

		if( $this->aow_get_option( 'tue_open', 'closed' ) == 'closed' ){
			$tuesday_is_open = 1;
		}else{
			$tuesday_is_open = 0;
		}
			$tuesday_array = array(
				$this->remove_leading_zero( $this->aow_get_option( 'tue_open' ) ),
				$this->remove_leading_zero( $this->aow_get_option( 'tue_closed' ) ),
				$tuesday_is_open,
				$this->aow_get_option( 'tue_msg' )
			);

		if( $this->aow_get_option( 'wed_open', 'closed' ) == 'closed' ){
			$wednesday_is_open = 1;
		}else{
			$wednesday_is_open = 0;
		}
			$wednesday_array = array(
				$this->remove_leading_zero( $this->aow_get_option( 'wed_open' ) ),
				$this->remove_leading_zero( $this->aow_get_option( 'wed_closed' ) ),
				$wednesday_is_open,
				$this->aow_get_option( 'wed_msg' )
			);

		if( $this->aow_get_option( 'thu_open', 'closed' ) == 'closed' ){
			$thursday_is_open = 1;
		}else{
			$thursday_is_open = 0;
		}
			$thursday_array = array(
				$this->remove_leading_zero( $this->aow_get_option( 'thu_open' ) ),
				$this->remove_leading_zero( $this->aow_get_option( 'thu_closed' ) ),
				$thursday_is_open,
				$this->aow_get_option( 'thu_msg' )
			);

		if( $this->aow_get_option( 'fri_open', 'closed' ) == 'closed' ){
			$friday_is_open = 1;
		}else{
			$friday_is_open = 0;
		}
			$friday_array = array(
				$this->remove_leading_zero( $this->aow_get_option( 'fri_open' ) ),
				$this->remove_leading_zero( $this->aow_get_option( 'fri_closed' ) ),
				$friday_is_open,
				$this->aow_get_option( 'fri_msg' )
			);

		if( $this->aow_get_option( 'sat_open', 'closed' ) == 'closed' ){
			$saturday_is_open = 1;
		}else{
			$saturday_is_open = 0;
		}
			$saturday_array = array(
				$this->remove_leading_zero( $this->aow_get_option( 'sat_open' ) ),
				$this->remove_leading_zero( $this->aow_get_option( 'sat_closed' ) ),
				$saturday_is_open,
				$this->aow_get_option( 'sat_msg' )
			);

		if( $this->aow_get_option( 'sun_open', 'closed' ) == 'closed' ){
			$sunday_is_open = 1;
		}else{
			$sunday_is_open = 0;
		}
			$sunday_array = array(
				$this->remove_leading_zero( $this->aow_get_option( 'sun_open' ) ),
				$this->remove_leading_zero( $this->aow_get_option( 'sun_closed' ) ),
				$sunday_is_open,
				$this->aow_get_option( 'sun_msg' )
			);


		$hours_array = array(
			$monday_array,
			$tuesday_array,
			$wednesday_array,
			$thursday_array,
			$friday_array,
			$saturday_array,
			$sunday_array,
		);

		return $hours_array;
		die();
	}

	function remove_leading_zero( $time ){
		if( $time == 'closed' ){
			$time = $time;
		}else{
			if( substr( $time, 0, 1) == 0 ){
				$time = substr( $time, 1 );
			}else{
				$time = $time;
			}
		}
		return $time;
	}

	function populate_aow_hub_node_hours_list($hours_array,$daylength){

		$day = $hours_array;

		$options_array = array(
			'ampm' 				=> $this->admin->get_option("ampmcase"),
			'ampmseparator' 	=> $this->admin->get_option("ampmseparator"),
			'trailing' 			=> $this->admin->get_option("trailingzero"),
			'separator' 		=> $this->admin->get_option("custom_separator"),
		);

		$monday_array = array(
			'day' 				=> 'Monday',
			'day_short' 		=> 'Mon',
			'day_id'			=> 1,
			'day_open' 			=> $day[0][0],
			'day_closing' 		=> $day[0][1],
			'day_closed' 		=> $day[0][2],
			'day_note'			=> isset($day[0][3]) ? $day[0][3] : "",
			'daylength' 		=> $daylength,
		);

		$tuesday_array = array(
			'day' 				=> 'Tuesday',
			'day_short' 		=> 'Tue',
			'day_id'			=> 2,
			'day_open' 			=> $day[1][0],
			'day_closing' 		=> $day[1][1],
			'day_closed' 		=> $day[1][2],
			'day_note'			=> isset($day[1][3]) ? $day[1][3] : "",
			'daylength' 		=> $daylength,
		);

		$wednesday_array = array(
			'day' 				=> 'Wednesday',
			'day_short' 		=> 'Wed',
			'day_id'			=> 3,
			'day_open' 			=> $day[2][0],
			'day_closing' 		=> $day[2][1],
			'day_closed' 		=> $day[2][2],
			'day_note'			=> isset($day[2][3]) ? $day[2][3] : "",
			'daylength' 		=> $daylength,
		);

		$thursday_array = array(
			'day' 				=> 'Thursday',
			'day_short' 		=> 'Thu',
			'day_id'			=> 4,
			'day_open' 			=> $day[3][0],
			'day_closing' 		=> $day[3][1],
			'day_closed' 		=> $day[3][2],
			'day_note'			=> isset($day[3][3]) ? $day[3][3] : "",
			'daylength' 		=> $daylength,
		);

		$friday_array = array(
			'day' 				=> 'Friday',
			'day_short' 		=> 'Fri',
			'day_id'			=> 5,
			'day_open' 			=> $day[4][0],
			'day_closing' 		=> $day[4][1],
			'day_closed' 		=> $day[4][2],
			'day_note'			=> isset($day[4][3]) ? $day[4][3] : "",
			'daylength' 		=> $daylength,
		);

		$saturday_array = array(
			'day' 				=> 'Saturday',
			'day_short' 		=> 'Sat',
			'day_id'			=> 6,
			'day_open' 			=> $day[5][0],
			'day_closing' 		=> $day[5][1],
			'day_closed' 		=> $day[5][2],
			'day_note'			=> isset($day[5][3]) ? $day[5][3] : "",
			'daylength' 		=> $daylength,
		);

		$sunday_array = array(
			'day' 				=> 'Sunday',
			'day_short' 		=> 'Sun',
			'day_id'			=> 7,
			'day_open' 			=> $day[6][0],
			'day_closing' 		=> $day[6][1],
			'day_closed' 		=> $day[6][2],
			'day_note'			=> isset($day[6][3]) ? $day[6][3] : "",
			'daylength' 		=> $daylength,
		);

		// Build hours containing list
		$hours_ul = "<ul class='child_hours_ul'>";
		$hours_ul .= $this->markup_day_hours( $monday_array, $options_array );
		$hours_ul .= $this->markup_day_hours( $tuesday_array, $options_array );
		$hours_ul .= $this->markup_day_hours( $wednesday_array, $options_array );
		$hours_ul .= $this->markup_day_hours( $thursday_array, $options_array );
		$hours_ul .= $this->markup_day_hours( $friday_array, $options_array );
		$hours_ul .= $this->markup_day_hours( $saturday_array, $options_array );
		$hours_ul .= $this->markup_day_hours( $sunday_array, $options_array );
		$hours_ul .= "</ul>";

		return $hours_ul;	

	}

	function aow_hub_node_time_return($time, $end, $ampm = "uppercase", $trailingzeros, $ampmseparator, $twentyfourhourtime = "false" ){

		$twentyfourhourtime = $twentyfourhourtime;
		$colon = '';

		if ($ampmseparator == "yes"):		
			if( $twentyfourhourtime == 'true' ){
				$time = date("G:i a",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));
			}else{
				$time = date("g:i a",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));	
			}
		else:
			if( $twentyfourhourtime == 'true' ){
				$time = date("G:ia",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));
			}else{
				$time = date("g:ia",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));
			}
		endif;

		if( $twentyfourhourtime == 'true' ){
			$am = '';
			$pm = '';
		}else{
			if( $ampm != 'none' ){
				if ($ampm == "uppercase"):	
					$am = "AM"; $pm = 'PM'; 
				else: 
					$am = 'am'; $pm = 'pm'; 
				endif;
			}else{
				 $am = "AM"; 
				 $pm = "PM";
			}
		}


		if($time >= 1200){
			if($time == 1200) {
				$time = 1200;
			} elseif($time == 1230) {
				$time = 1230;
			} elseif( $twentyfourhourtime == 'true' ){
				$time = $time;
			} else {
				if (!is_array($time)):
					$time = ($time-1200);
				endif;
			}

			if ($trailingzeros == "no" && strpos(substr($time,-6),"00") !== FALSE):
				$time = str_replace( ":00","",$time);
			else:
				$time = substr_replace( $time , $colon , -2, 0);
			endif;

			$time = str_replace("am",$am,$time);
			$time = str_replace("pm",$pm,$time);

			return $time;
			exit;

		}else{

			if ($trailingzeros == "no" && strpos(substr($time,-6),"00") !== FALSE):
				$time = str_replace(":00","",$time);
			else:
				$time = substr_replace( $time , $colon , -2, 0);
			endif;

			$time = str_replace("am",$am,$time);
			$time = str_replace("pm",$pm,$time);

			return $time;
			exit;
		}
	}

	// Markup raw hour info in an li for the hours list
	function markup_day_hours( $day_array, $options_array ){

		$day_array = $day_array;
		$options_array = $options_array;


		$hours_ul = "<li>";
		if ($day_array[ 'daylength' ] == "long" || $day_array[ 'daylength' ] == 1):
			$hours_ul .= "<span class='child_dayofweek_long'><time day='" . $day_array[ 'day_id' ] . "' itemprop='weekDay'>" . $day_array[ 'day' ] . ":</time></span>";
		else:
			$hours_ul .= "<span class='child_dayofweek'>" . $day_array[ 'day_short' ] . ":</span>";
		endif;

		$hours_ul .= "<span class='child_hours'>";

		if ($day_array[ 'day_closed' ] == 1):
			$hours_ul .= "<span class='child_replace'>Closed";
			$hours_ul .= "</span>";
		else:
			$hours_ul .= "<span class='child_hours'>";
			$hours_ul .= "<time time='".$this->aow_hub_node_time_return($day_array[ 'day_open' ],0,$options_array[ 'ampm' ],$options_array[ 'trailing' ],$options_array[ 'ampmseparator' ])."' itemprop='startTime'>".$this->aow_hub_node_time_return($day_array[ 'day_open' ],0,$options_array[ 'ampm' ],$options_array[ 'trailing' ],$options_array[ 'ampmseparator' ])."</time>";
			$hours_ul .= "<span class='child_dash'>".$options_array[ 'separator' ]."</span>";
			$hours_ul .= "<time time='".$this->aow_hub_node_time_return($day_array[ 'day_closing' ],1,$options_array[ 'ampm' ],$options_array[ 'trailing' ],$options_array[ 'ampmseparator' ])."' itemprop='endTime'>".$this->aow_hub_node_time_return($day_array[ 'day_closing' ],1,$options_array[ 'ampm' ],$options_array[ 'trailing' ],$options_array[ 'ampmseparator' ])."</time>";
			$hours_ul .= "</span>";
		endif;

		if (strlen($day_array[ 'day_note' ]) > 0): 
			$hours_ul .= " <span class='child_note'>".$day_array[ 'day_note' ]."</span>"; 
		endif;

		$hours_ul .= "</span>";
		$hours_ul .= "</li>";

		return $hours_ul;
		die();
	}
}

