<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://aheadoftheweb.com/
 * @since      1.0.0
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 * @author     Graeme <Gibson>
 */
class Aow_Hub_Node_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;
	
	/**
	 * Instantiated connection class
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      AowHubNodeConnection    $version    Instantiated connection class
	 */
	private $network;
	
	/**
	 * Tablist array for admin settings page
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      AowHubNodeConnection    $version    Tablist array for admin settings page
	 */
	public $tablist = array(
			'default'			=> 'Default Info',
			'clinic'			=> 'Clinics',
			'clinic-city'		=> 'Cities',
			'clinic-service'	=> 'Services',
			'clinic-staff'		=> 'Staff',
			'clinic-language'	=> 'Languages',
	);
	
	/**
	 * Instantiated connection class
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      AowHubNodeConnection    $version    Instantiated connection class
	 */
	private $customizer;
	
	public $current_posttype;
	
	public $data;

	/**
	 * Admin Settings Page Options
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      options    $version    Admin Settings Page Options
	 */
	public $options = array();

	public $current_Section;
	
	/**
	 * Admin Section Settings
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      options    $version    Admin Settings Page Options
	 */
	public $section_settings = array();


	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
		$this->options = $this->get_options();
		$this->network = $this->get_network();
		$this->customizer = $this->get_customizer();
		$this->data = $this->get_data();
		$this->helper = $this->get_helper();
		$this->current_posttype = $this->get_current_posttype();
		$this->current_section = 'default';
		$this->shortcode_get_clinic_info( $this );
		
		
		
		add_action( 'widgets_init', array( $this, 'load_widgets' ) );
		add_action( 'admin_menu', array( $this, 'add_admin_menu' ) );
		add_action( 'admin_init', array( $this, 'init_settings'  ) );

	}
	
	public function get_current_posttype(){
		$current_posttype = 'default';
		if( array_key_exists( 'tab', $_GET ) ){
			$current_posttype = $_GET[ 'tab' ];
			$this->set_option( array( 'current_posttype' => $current_posttype ) );
		}else{
			$current_posttype = $this->get_option( 'current_posttype' );
		}

		return $current_posttype;
	}
	
	private function shortcode_get_clinic_info( $admin ){
		global $admin;
		$admin = $this;
		include plugin_dir_path( dirname( __FILE__ ) ) . 'includes/shortcode-get_clinic_info.php';
	}
	
	private function get_data(){
		$data = new Aow_Hub_Node_Data( $this->plugin_name, $this->version, $this );
		return $data;
	}
	
	private function get_helper(){
		$data = new Aow_Hub_Node_Helper( $this );
		return $data;
	}
	
	public function get_options(){
		$options = get_option( 'aow_hub_node_settings' );
		if( $options ){
			return $options;
		}else{
			return array();
		}
	}
	
	public function get_option( $option ){
		if( $this->options && array_key_exists( $option, $this->options ) ){
			return $this->options[ $option ];
		}else{
			return false;
		}
	}
	
	public function set_option( $new_options = array()  ){
		$options = $this->get_options();
		foreach( $new_options as $k => $v ){
			$options[ $k ] = $v;
		}
		update_option( 'aow_hub_node_settings', $options );
		$this->get_options();
	}
	
	public function unset_option( $option ){
		$options = $this->get_options();
		unset( $options[ $option ] );
		update_option( 'aow_hub_node_settings', $options );
		$this->get_options();
	}
	
	public function get_network() {
		
		//Instantiate network class
		$network = new Aow_Hub_Node_Connection( $this );
		
		// Populate object with endpoint if we have one
		if( array_key_exists( 'network_end_point', $this->options ) ){
			$network->endpoint = $this->options[ 'network_end_point' ];
		}
		
		return $network;

	}
	
	public function load_cpts(){
		$this->cpt[ 'clinic-city' ] 			= new Aow_Hub_Node_CPT_City( $this );
		$this->cpt[ 'clinic' ] 					= new Aow_Hub_Node_CPT_Clinic( $this );
		$this->cpt[ 'clinic-language' ] 		= new Aow_Hub_Node_CPT_Language( $this );
		$this->cpt[ 'clinic-staff' ]	 		= new Aow_Hub_Node_CPT_Staff( $this );
		$this->cpt[ 'clinic-service' ] 			= new Aow_Hub_Node_CPT_Service( $this );
	}
	
	public function load_widgets(){
		$this->widget[ 'clinic_hours' ] 		= new Aow_Hub_Node_Widget_Clinic_Hours( $this );
		$this->widget[ 'clinic_promotions' ] 	= new Aow_Hub_Node_Widget_Clinic_Promotions( $this );
			
		foreach( $this->widget as $widget ){
			register_widget( $widget );	
		}
	}
		
	public function get_customizer() {
		
		//Instantiate network class
		$this->cpt[ 'default' ] = new Aow_Hub_Node_Customizer( $this );
	}
	
	public function execute_page_vars(){
		// Handle external requests (push cip, hours, promotions, etc)
		if(isset($_GET['task']) && $_GET['task']=="pushcontent"){
			if(isset($_GET['id'])){
				//aowpromotionscontentchildfetchfeed($_GET['id']);
			}
			die;
		}
		// Handle form submissions from settings pages 
		if( $_POST && array_key_exists( 'action', $_POST ) && $_POST[ 'action' ] == 'get_data' ){
			if( array_key_exists( 'data', $_POST ) ){
				if( $_POST[ 'data' ] == 'Get New Data' || $_POST[ 'data' ] == 'Get Data' ){
					if( $this->current_posttype == 'default' ){
							if( $this->get_option( 'hub_node_clinic' ) ){
								$data = $this->network->get_data( 'clinic-single', $this->get_option( 'hub_node_type' ), $this->get_option( 'hub_node_clinic' ) );
								$data = json_decode( $data );
								if( $data->status->error ){
									$this->set_option( array( 'key' => 'get' ) );
									$data_new_var = 'data_new_' . $this->current_posttype;
									$this->set_option( array( $data_new_var => FALSE ) );
								}else{
									$data = json_decode( json_encode( $data->data ), TRUE );
									$data = reset( $data );
									$data = json_decode( json_encode( $data ) );
									$data_put_result = $this->cpt[ 'clinic' ]->get_meta( $data->cip );
									$new_data = array();
									foreach( $data_put_result as $k => $v ){
										$new_data[ $k ] = array( $v ); 
									}
									$data = array( array( 'meta' => $new_data ) );
									$data_new_var = 'data_new_' . $this->current_posttype;
									$this->set_option( array( $data_new_var => $data ) );
								}
								
								
								$this->set_option( array( 'key' => 'get' ) );
								$data_new_var = 'data_new_' . $this->current_posttype;
								$this->set_option( array( $data_new_var => $data ) );
							}else{
								$data = '{}';
							}
						//}
					}else{
						$node_type = $this->get_option( 'hub_node_type' );
						if( $node_type && $node_type == 2 ){
							$data = $this->network->get_data( 'clinic-single', $this->get_option( 'hub_node_type' ), $this->get_option( 'get_clinics' ) );
						}else{
							$data = $this->network->get_data( $this->current_posttype, $this->get_option( 'hub_node_type' ), $this->get_option( 'custom_brand' ) );	
						}
						$data = json_decode( $data );
						if( $data->status->error ){
							$this->set_option( array( 'key' => 'get' ) );
							$data_new_var = 'data_new_' . $this->current_posttype;
							$this->set_option( array( $data_new_var => FALSE ) );
						}else{
							$data_new_var = 'data_new_' . $this->current_posttype;
							$this->set_option( array( $data_new_var => $data->data ) );
						}
					}
					
				}else if( $_POST[ 'data' ] == 'Clear New Data' ){
					$data_new_var = 'data_new_' . $this->current_posttype;
					$this->unset_option( $data_new_var );
				}else if( $_POST[ 'data' ] == 'Apply New Data' ){
					$data_new_var = 'data_new_' . $this->current_posttype;
					if( $this->current_posttype == 'default' ){
						$options = $this->get_option( $data_new_var );
						$options = reset( $options );
						$data_put_result = $this->cpt[ 'default' ]->set_option( $options[ 'meta' ] );
					}else{
						$data_put_result = $this->data->set_cip( $this->get_option( $data_new_var ), $this->current_posttype );
					}
					if( $data_put_result ){ 
						$this->unset_option( $data_new_var );
					}
				}else if( $_POST[ 'data' ] == 'Set As Current Data' ){
					$data_new_var = 'data_new_' . $this->current_posttype;
					$this->set_option( array( 'data' => $this->get_option( $data_new_var ) ) );
					$this->unset_option( 'data_live' );
					$this->unset_option( $data_new_var );
				}else if( $_POST[ 'data' ] == 'Save Options' ){
					$new_options = $_POST[ 'aow_hub_node_settings' ];
					$this->set_option( $new_options );
				}
			}
		// Handle form submissions from settings pages
		}
		// Set tab navigation so that we re-direct to the correct page
		$tab = $this->current_posttype;
		if( $tab ){
			$this->set_option( array( 'current_posttype', $this->current_posttype ) );
			$refresh_url = admin_url( 'admin.php?page=aow_hub_node&tab=' . $tab, 'https' );
		}else{
			$refresh_url = admin_url( 'admin.php?page=aow_hub_node', 'https' );
		}
		header("Location: $refresh_url", true, 301);
		exit();
	}
	
	public function add_admin_menu() {

		add_menu_page(
			esc_html__( 'AOW HUB NODE Settings', 'text_domain' ),
			esc_html__( 'AOW HUB NODE', 'text_domain' ),
			'manage_options',
			'aow_hub_node',
			array( $this, 'page_layout' ),
			'dashicons-networking',
			80
		);
		
		add_submenu_page( 
			'aow_hub_node', 
			'Hours' , 
			'Hours' , 
			'manage_options' , 
			'aow_hub_node_hours' , 
			array( $this, 'aow_hub_node_hours' ) 
		);
		
		add_submenu_page( 
			'aow_hub_node', 
			'Reset WP Touch', 
			'Reset WP Touch', 
			'manage_options', 
			'aow_hub_node_wptouch', 
			array( $this, 'aow_hub_node_reset_wp_touch' ) 
		);
		
		add_submenu_page( 
			'aow_hub_node', 
			'Promotions', 
			'Promotions', 
			'manage_options', 
			'aow_hub_node_promos', 
			array( $this, 'aow_hub_node_promotions' ) 
		);

	}

	public function init_settings() {

		register_setting(
			'aow_hub_node',
			'aow_hub_node_settings'
		);

		add_settings_section(
			'aow_hub_node_settings_section',
			'',
			false,
			'aow_hub_node_settings'
		);
		
		add_settings_field(
			'hub_node_type',
			__( 'Select Node Type', 'text_domain' ),
			array( $this, 'render_hub_node_type_field' ),
			'aow_hub_node_settings',
			'aow_hub_node_settings_section'
		);
		add_settings_field(
			'network_end_point',
			__( 'Network End Point', 'text_domain' ),
			array( $this, 'render_network_end_point_field' ),
			'aow_hub_node_settings',
			'aow_hub_node_settings_section'
		);
		add_settings_field(
			'custom_brand',
			__( 'Brand ID', 'text_domain' ),
			array( $this, 'render_custom_brand_field' ),
			'aow_hub_node_settings',
			'aow_hub_node_settings_section'
		);


	}

	public function page_layout() {
		
		// Check required user capability
		if ( !current_user_can( 'manage_options' ) )  {
			wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'text_domain' ) );
		}
		$this->current_section = 'default';
		include( 'partials/aow-hub-node-admin-display.php' );
	}
	
	public function aow_hub_node_hours(){
		$this->current_section = 'hours';
		include( 'partials/aow-hub-node-admin-display.php' );
	}
	
	public function aow_hub_node_reset_wp_touch(){
		$this->current_section = 'wptouch';
		include( 'partials/aow-hub-node-admin-display.php' );
	}
	
	public function aow_hub_node_promotions(){
		$this->current_section = 'promo';
		include( 'partials/aow-hub-node-admin-display.php' );
	}
	
	function render_hub_node_section_sidebar() {
		include( 'partials/aow-hub-node-admin-sidebar.php' );
	}
	
	function render_hub_node_section_body() {
		include( 'partials/aow-hub-node-admin-body.php' );
	}
	
	function render_hub_node_section_hours() {
		include( 'partials/aow-hub-node-admin-hours.php' );
	}
	
	function render_hub_node_section_wptouch() {
		include( 'partials/aow-hub-node-admin-resetwptouch.php' );
	}
	
	function render_hub_node_section_promo() {
		include( 'partials/aow-hub-node-admin-promotions.php' );
	}
	
	function render_hub_node_get_section() {
		$this->section_settings[ 'data_new' ] = FALSE;
		$this->section_settings[ 'data' ] = TRUE;
		$posttype = $this->cpt[ $this->current_posttype ];
		$tab = $posttype->posttype;
		$this->section_settings[ 'title' ] = $posttype->singular;
		$tab_label = $this->tablist[ $tab ];
		if( $posttype->posttype == 'default' ){
			$data_table = 'populate with customizer options.';
			$clinic = $this->cpt[ 'default' ];
			$field_sections = $clinic->get_field_array();
			$data_table = '<table class="aow-hub-node-table-list">';
			$data_table_body = '';
			$data_new_var = 'data_new_' . $this->current_posttype;
			$data_new = $this->get_option( $data_new_var );
			if( $data_new && is_array( $data_new ) ){
				$data_new = reset( $data_new );
				$this->section_settings[ 'data_new' ] = TRUE;
				foreach( $field_sections as $field_section){
					foreach( $field_section as $field ){
						if( !array_key_exists( 'ignore', $field ) || $field[ 'ignore' ] != 'true' ){
							$meta_key = substr( $field[ 'id' ], 4 );
							$meta_value = ( array_key_exists( $meta_key, $data_new[ 'meta' ] ) ) ? $data_new[ 'meta' ][ $meta_key ][ 0 ] : 'Not Found in Meta';
							$data_table_body .= '<tr>';
							if( $meta_value == $this->cpt[ 'default' ]->get_option( $meta_key ) ){
								$data_table_body .= '<td class="statuscell"><span class="span-change span-change-msg">No Changes</span></td>';
							}else{
								$data_table_body .= '<td class="statuscell"><span class="span-change span-change-warning">Changes</span></td>';
							}
							$data_table_body .= '<td id="' . $field[ 'id' ] . '">' . $field[ 'label' ] . '</td>';
							$data_table_body .= '<td>' . $this->cpt[ 'default' ]->get_option( $meta_key ) . '</td>';
							$data_table_body .= '<td id="' . $meta_key . '">' . $meta_value . '</td>';
							$data_table_body .= '</tr>';
						}
					}

				}
			}else{
				foreach( $field_sections as $field_section){
					foreach( $field_section as $field ){
						if( !array_key_exists( 'ignore', $field ) || $field[ 'ignore' ] != 'true' ){
							$meta_key = substr( $field[ 'id' ], 4 );
							$data_table_body .= '<tr>';
							$data_table_body .= '<td></td>';
							$data_table_body .= '<td id="' . $field[ 'id' ] . '">' . $field[ 'label' ] . '</td>';
							$data_table_body .= '<td>' . $this->cpt[ 'default' ]->get_option( $meta_key ) . '</td>';
							$data_table_body .= '<td></td>';
							$data_table_body .= '</tr>';
						}
					}

				}	
			}
			$data_table .= '<thead><tr>';
			$data_table .= '<th>Status</th>';
            $data_table .= '<th>Field</th>';
            $data_table .= '<th>Current Value:</th>';
            $data_table .= '<th>New Value:</th>';
            $data_table .= '</tr></thead>';
			$data_table .= $data_table_body;
            $data_table .= '</table>';
		}else{
			// Get current data from database
			$data = $this->data->get_data( 'all', 'all', $posttype );
			$data_new_var = 'data_new_' . $this->current_posttype;
			$data_new = $this->get_option( $data_new_var );
			if( !$data ){ 
				$this->section_settings[ 'data' ] = FALSE;
				$data = array(); 
			}
            // Check whether we need to compare versus newly retreived data
            if( $data_new ){
                $this->section_settings[ 'data_new' ] = TRUE;
                // There is new data and we need to build the comparison table
                $data_new_array = json_decode( json_encode( $data_new ), true );
                $data_new_objects = array();
                $data_new_count = count( $data_new_array );
                $data_table = '<table class="aow-hub-node-table-list">';
                $data_table_body = '';
                foreach( $data as $k => $v ){
                    $data_table_body .= '<tr>';
                    if( array_key_exists( $k, $data_new_array ) ){
                        if( !array_key_exists( 'cip', $v[ 'meta' ] ) ){
                            $v[ 'meta' ][ 'cip' ][ 0 ] = '{}';
                        }

                        $current_data = json_decode( $v[ 'meta' ][ 'cip' ][0], TRUE );

                        if( $current_data == $data_new_array[ $k ][ 'cip' ] ){

                            $data_table_body .= '<td class="statuscell"><span class="span-change span-change-msg">No Changes</span></td>';
                        }else{
                            $data_table_body .= '<td class="statuscell"><span class="span-change span-change-warning">Changes</span></td>';
                        }
                        $data_table_body .= '<td>[' . $k . '] ' . $v[ 'post' ]->post_title . '</td>';
                        $data_table_body .= '<td>[' . $k . '] ' . $data_new_array[ $k ][ 'name' ] . '</td>';
                        unset( $data_new_array[ $k ] );
                    }else{
                        $data_table_body .= '<td class="statuscell"><span class="span-change span-change-alert">' . $this->cpt[ $this->get_option( 'current_posttype' ) ]->singular . ' to Delete</span></td>';
                        $data_table_body .= '<td>[' . $k . '] ' . $v[ 'post' ]->post_title . '</td>';
                        $data_table_body .= '<td></td>';	
                    }
                    $data_table_body .= '</tr>';
                }
                foreach( $data_new_array as $k => $v ){
                    $data_table_body .= '<tr>';
                    $data_table_body .= '<td class="statuscell"><span class="span-change span-change-success">New ' . $this->cpt[ $this->get_option( 'current_posttype' ) ]->singular . '</span></td>';
                    $data_table_body .= '<td></td>';
                    $data_table_body .= '<td>[' . $k . '] ' . $v[ 'name' ] . '</td>';
                    $data_table_body .= '</tr>';
                }
                $data_table .= '<thead><tr>';
                $data_table .= '<th>Status</th>';
                $data_table .= '<th>Posts in Database: ' . count( $data ) . '</th>';
                $data_table .= '<th>Posts in new Dataset: ' . $data_new_count . '</th>';
                $data_table .= '</tr></thead>';
                $data_table .= $data_table_body;
                $data_table .= '</table>';
            }else{
                // There is no comparison needed, just show current database fields
                $data_table = '<table class="aow-hub-node-table-list">';
                $data_table_body = '';
                foreach( $data as $k => $v ){
                    $data_table_body .= '<tr><td>[' . $k . '] ' . $v[ 'post' ]->post_title . '</td></tr>';
                }
                $data_table .= '<thead><tr><th>Posts in Database: ' . count( $data ) . '</th></tr></thead>';
                $data_table .= $data_table_body;
                $data_table .= '</table>';
            }
		}
		
		$this->section_settings[ 'data_table' ] = $data_table;

		switch( $tab ){
			case 'default':
				include( 'partials/aow-hub-node-admin-tab-default.php' );
				break;
			default:
				include( 'partials/aow-hub-node-admin-tab-posttype.php' );
				break;
		}
	}
	
	function render_hub_node_type_field() {

		$value = $this->get_option( 'hub_node_type' );
		// Field output.
		echo '<div class="aow-hub-node-field-group">';
		echo '<h2>Select Node Type</h2>';
		echo '<select name="aow_hub_node_settings[hub_node_type]" class="hub_node_type_field">';
		echo '	<option value="1" ' . selected( $value, '1', false ) . '> ' . __( 'Single Clinic', 'text_domain' ) . '</option>';
		echo '	<option value="2" ' . selected( $value, '2', false ) . '> ' . __( 'Multiple Clinics', 'text_domain' ) . '</option>';
		echo '	<option value="3" ' . selected( $value, '3', false ) . '> ' . __( 'Clinic Group', 'text_domain' ) . '</option>';
		echo '</select>';
		//echo '<p class="description">' . __( 'What type of node does this website represent', 'text_domain' ) . '</p>';
		echo '</div>';

	}
	
	function render_hub_node_clinic_field() {

		$selected_value = $this->get_option( 'hub_node_clinic' );
		$node_type = $this->get_option( 'hub_node_type' );
		// Field output.
        echo '<input type="text" name="aow_hub_node_settings[hub_node_clinic]" class="text network_clinic_field" placeholder="' . esc_attr__( '', 'text_domain' ) . '" value="' . esc_attr( $selected_value ) . '">';
	}
	
	function render_network_end_point_field() {

		$value = $this->get_option( 'network_end_point' );

		// Field output.
		echo '<div class="aow-hub-node-field-group">';
		echo '<h2>Network End Point</h2>';
		echo '<input type="url" name="aow_hub_node_settings[network_end_point]" class="large-text network_end_point_field" placeholder="' . esc_attr__( '', 'text_domain' ) . '" value="' . esc_attr( $value ) . '">';
		//echo '<p class="description">' . __( 'Enter a network endpoint to get data from', 'text_domain' ) . '</p>';
		echo '</div>';

	}
	
	
	function render_hub_node_get_clinics() {

		$value = $this->get_option( 'get_clinics' );

		// Field output.
		echo '<div class="aow-hub-node-field-group">';
		echo '<h2>Clinic IDs</h2>';
		echo '<input type="text" name="aow_hub_node_settings[get_clinics]" class="text get_clinics_field" placeholder="' . esc_attr__( '', 'text_domain' ) . '" value="' . esc_attr( $value ) . '">';
		echo '<p class="description">' . __( 'Separate multiple IDs with apostrophes', 'text_domain' ) . '</p>';
		echo '</div>';

	}
	
	function render_custom_brand_field() {

		if( $this->get_option( 'hub_node_type' ) == 3 ){
			$value = $this->get_option( 'custom_brand' );
			// Field output.
			echo '<div class="aow-hub-node-field-group">';
			echo '<h2>Custom Brand ID</h2>';
			echo '<input type="number" name="aow_hub_node_settings[custom_brand]" class="large-text custom_brand_field" placeholder="' . esc_attr__( '', 'text_domain' ) . '" value="' . esc_attr( $value ) . '">';
			//echo '<p class="description">' . __( 'Custom brand ID', 'text_domain' ) . '</p>';
			echo '</div>';
		}

	}
	
	function render_connection_status_message() {
		$key = ( $this->get_option( 'key' ) ) ? $this->get_option( 'key' ) : 'authenticate';
		$status = $this->network->get_status( $key );
		$this->unset_option( 'key' );
		echo '<div id="aow-hub-node-status-message" class="notice notice-' . $status[ 'notice' ] . ' inline">';
		echo '<p><strong>Network Connection Status: </strong>' . $status[ 'msg' ] . '</p>';
		echo '</div>';
	}
	
	
	function get_new_data(){
		if ( array_key_exists( 'post_type', $_GET ) && $_GET['post_type'] == $this->ID and is_admin() and 'edit.php' == $pagenow and !isset($_GET['orderby'])) {
				$wp_query->set( 'orderby', 'title' );
				$wp_query->set( 'order', 'ASC' );
			}
	}


	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Aow_Hub_Node_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Aow_Hub_Node_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/aow-hub-node-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Aow_Hub_Node_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Aow_Hub_Node_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/aow-hub-node-admin.js', array( 'jquery' ), $this->version, false );

	}
	
	

}
