<?php // Add module-specific filters to backend helper to make modifying field content in visual builder easier

add_filter('et_fb_backend_helpers', 'dbdse_decode_shortcodes_in_backend_helpers');

function dbdse_decode_shortcodes_in_backend_helpers($helpers) {
	if (isset($helpers['shortcode_object']) && is_array($helpers['shortcode_object'])) {
		foreach($helpers['shortcode_object'] as $section_key=>$section) {
			if (isset($section['content']) && is_array($section['content'])) {
				foreach($section['content'] as $row_key=>$row) {
					if (isset($row['content']) && is_array($row['content'])) {
						foreach($row['content'] as $column_key=>$column) {
							if (isset($column['content']) && is_array($column['content'])) {
								foreach($column['content'] as $module_key=>$module) {
									if (isset($module['type'])) {
										$helpers['shortcode_object'][$section_key]['content'][$row_key]['content'][$column_key]['content'][$module_key] = apply_filters('dbdse_et_fb_backend_helpers_module', $module, $module['type']);
									}
								}
							}
						}
					}
				}
			}
		}
	}
	return $helpers;
}