<?php
/*
Plugin Name: Divi Shortcode Enabler
Plugin URI: https://divibooster.com
Description: Runs shortcodes where Divi doesn't let you.
Author: Divi Booster
Version: 1.0.8
Author URI: https://divibooster.com
*/

define('DBDSP_VERSION', '1.0.8');
define('DBDSE_FILE', __FILE__);
define('DBDSE_DIR', dirname(__FILE__));

include_once(DBDSE_DIR.'/admin/licensing.php');
include_once(DBDSE_DIR.'/classes/DBDSE_Url.php');
include_once(DBDSE_DIR.'/hooks/dbdse_et_fb_backend_helpers_module.php');
include_once(DBDSE_DIR.'/hooks/dbdse_et_pb_layout_content.php');
include_once(DBDSE_DIR.'/core/DBDSE_EnableShortcodesInModuleFields.php');

// === Updates ===

if (get_option('dbdse_license_status') === 'valid') {
	
	$updatename = 'divi-shortcode-processor';
	$updateurl = 'https://d2hhmc1yvsixby.cloudfront.net/updates.json'; 
	include_once(dirname(__FILE__).'/updates/plugin-update-checker.php');
	try {
		$MyUpdateChecker = new DMWP_PluginUpdateChecker_1_0_0($updateurl, __FILE__, $updatename);
	} catch (Exception $e) {}
}

// === Register shortcodes for use in the fields ===

add_action('dbdsp_pre_shortcode_processing', 'dbdsp_register_shortcodes');
add_action('dbdsp_post_shortcode_processing', 'dbdsp_deregister_shortcodes');

function dbdsp_register_shortcodes() {
	add_shortcode('site_url', 'dbdsp_shortcode_site_url'); 
	add_shortcode('custom_field', 'dbdsp_shortcode_custom_field'); 
}

function dbdsp_deregister_shortcodes() {
	remove_shortcode('site_url'); 
	remove_shortcode('custom_field'); 
}

// Shortcode to return the site URL
function dbdsp_shortcode_site_url() {
    return site_url();
}

// Shortcode to return the value from a custom field
function dbdsp_shortcode_custom_field($args) {
	global $post;
	
	$args = wp_parse_args($args, array(
		'name' => '',
		'post_id' => $post->ID
	));

	$key = $args['name'];
	if (empty($key)) { return ''; }

	return get_post_meta($args['post_id'], $key, true);
}
add_shortcode('custom_field', 'dbdsp_shortcode_custom_field');

// === Handle visual builder formatting of URL fields ===

add_filter('et_fb_load_raw_post_content', 'dbdse_restore_shortcode_formatting_in_visual_builder_url_fields');

function dbdse_restore_shortcode_formatting_in_visual_builder_url_fields($content) {
	add_filter('clean_url', 'dbdse_strip_added_protocol_when_url_starts_with_shortcode', 10, 3);
	return $content;
}

function dbdse_strip_added_protocol_when_url_starts_with_shortcode($cleanUrlStr, $originalUrlStr, $context) { 
	if ($context !== 'db') { return $cleanUrlStr; } // Exit if not in Divi Builder context
	$url = new DBDSE_Url($cleanUrlStr);
	if ((new DBDSE_Url($originalUrlStr))->startsWithShortcode()) {
		$url->removeProtocol();
	} 
	$url->decodeShortcodes();
	return $url->toString();
}

// === Fix http appended to shortcodes in button link url ===

add_filter('et_pb_module_shortcode_attributes', 'dbdse_remove_protocol_from_button_url_in_visual_builder', 10, 3);

function dbdse_remove_protocol_from_button_url_in_visual_builder($props, $attrs, $render_slug) {
	if ($render_slug === 'et_pb_button' && dbdse_et_fb_processing_shortcode_object()) {
		if (isset($attrs['button_url']) && isset($props['button_url'])) {
			$url_original = $attrs['button_url'];
			$url_processed = $props['button_url'];
			if (dbdse_original_attribute_contains_shortcode($url_original) && strpos($url_original, 'http://') !== 0) {
				$props['button_url'] = preg_replace('#^http:\/\/#', '', $props['button_url']);
			}
		}
	}
	return $props;	
}

function dbdse_original_attribute_contains_shortcode($value) {
	return (strpos($value, '%91') !== false && strpos($value, '%93') !== false);
}

function dbdse_et_fb_processing_shortcode_object() {
	global $et_fb_processing_shortcode_object;
	return $et_fb_processing_shortcode_object;
}

// === Disable validation on circle counter number field ===

add_filter('et_pb_all_fields_unprocessed_et_pb_circle_counter', 'dbdse_disable_validation_on_circle_counter_number_field'); 

function dbdse_disable_validation_on_circle_counter_number_field($fields) {
	unset($fields['number']['number_validation']);
	unset($fields['number']['value_type']);
	unset($fields['number']['value_min']);
	unset($fields['number']['value_max']);	
	return $fields;
}

// === Handle shortcodes in backend helper for bfb
add_filter('dbdse_et_fb_backend_helpers_module', 'dbdse_decode_shortcode_in_param', 10, 2);

function dbdse_decode_shortcode_in_param($module, $render_slug) {
	$supported_fields = DBDSE_EnableShortcodesInModuleFields::supportedFields();
	if (in_array($render_slug, array_keys($supported_fields))) {
		foreach($supported_fields[$render_slug] as $field) {
			if (isset($module['attrs'][$field])) {
				$module['attrs'][$field] = str_replace(array('%91', '%93'), array('[', ']'), $module['attrs'][$field]);
			}
		}
	}
	return $module;
}