<?php 

if (!class_exists('DBDSE_EnableShortcodesInModuleFields')) {
	class DBDSE_EnableShortcodesInModuleFields {

		static public function supportedFields() {
			return apply_filters(
				'dbdsp_fields_to_process', 
				array(
					'et_pb_accordion_item' => array('title'),
					'et_pb_blurb' => array('title', 'url', 'image', 'alt'),
					'et_pb_button' => array('button_url', 'button_text'),
					'et_pb_circle_counter' => array('title', 'number'),
					'et_pb_cta' => array('title', 'button_text', 'button_url'),
					'et_pb_image' => array('url', 'src', 'title_text', 'alt'),
					'et_pb_number_counter' => array('title', 'number'),
					'et_pb_counter' => array('percent'), 
					'et_pb_pricing_table' => array('title', 'subtitle', 'currency', 'sum', 'button_text', 'button_url'),
					'et_pb_tab' => array('title'),
					'et_pb_slide' => array('heading', 'button_text', 'button_link', 'image_alt', 'title_text'),
					'db_pb_slide' => array('button_text_2', 'button_link_2'), // Divi Booster added second slide buttons
					'et_pb_fullwidth_header' => array('title', 'subhead', 'button_one_text', 'button_two_text', 'button_one_url', 'button_two_url'),
					'et_pb_fullwidth_image' => array('src', 'title_text', 'alt'),
					'et_pb_contact_field' => array('field_title')
				)
			);
		}
		
		public function init() {
			add_filter('the_content', array($this, 'processShortcodes')); // Standard content
			add_filter('et_builder_render_layout', array($this, 'processShortcodes')); // Theme builder layout content
			add_filter('dbdse_et_pb_layout_content', array($this, 'processShortcodes')); // Global module content
		}

		public function processShortcodes($content) {
			$modules = self::supportedFields();
			do_action('dbdsp_pre_shortcode_processing');
			foreach((array) self::supportedFields() as $module=>$fields) {
				foreach($fields as $field) {
					$regex = '#\['.preg_quote($module).' [^\]]*?\b'.preg_quote($field).'="([^"]+)"#';
					$content = preg_replace_callback($regex, array($this, 'processMatchedAttribute'), $content);
				}
			}
			do_action('dbdsp_post_shortcode_processing');
			return $content;
		}

		protected function processMatchedAttribute($matches) {
			
			// Exit if not properly matched
			if (!is_array($matches) || !isset($matches[0])) { return ''; } 
			if (!isset($matches[1])) { return $matches[0]; }
			
			// Define character replacements
			$encoded = array('%22', '%91', '%93');
			$decoded = array('"', '[', ']');
				
			// Get the decoded parameter value
			$val = $matches[1];
			$val = str_replace($encoded, $decoded, $val); // decode encoded characters
			$val = do_shortcode($val);
			$val = str_replace($decoded, $encoded, $val); // re-encode

			// Return the replacement value
			$result = str_replace($matches[1], $val, $matches[0]);

			return $result;
		}
	}
	(new DBDSE_EnableShortcodesInModuleFields)->init();
}