<?php

class DBDSE_Url {
	
	protected $url;
	
	function __construct($url='') {
		$this->url = $url;
	}
	
	public function decodeShortcodes() {
		$this->decodeBrackets();
		$this->url = preg_replace_callback('/\[(.*?)\]/', array($this, 'urlDecodeMatch'), $this->url);
	}
	function urlDecodeMatch($matches) {
		return isset($matches[0])?urldecode($matches[0]):'';
	}
	
	public function removeProtocol() {
		$this->url = preg_replace('/^http:\/\//', '', $this->url);
	}
	
	public function toString() {
		return $this->url;
	}
	
	public function replace($old, $new) {
		$this->url = str_replace($old, $new, $this->url);
	}
	
	public function decodeBrackets() {
		$this->replace(
			array('&#91;', '&#93;', '%91', '%93'),
			array('[', ']', '[', ']')
		);
	}
	
	public function startsWith($str) {
		return (strpos($this->url, $str) === 0);
	}
	
	public function startsWithShortcode() {
		return $this->startsWith('&#91;') || $this->startsWith('%91') || $this->startsWith('[');
	}
}