<?php
class ET_Builder_Module_Aow_Custom extends ET_Builder_Module {
	function init() {
		$this->name            = esc_html__( 'AOW HUB NODE - Get Clinics', 'et_builder' );
		$this->plural          = esc_html__( 'AOW HUB NODE - Get Clinics', 'et_builder' );
		$this->slug            = 'et_pb_aow_hub_node_get_clinics';
		$this->vb_support      = 'on';
		$this->use_raw_content = true;

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'main_content' => esc_html__( 'AOW HUB NODE - Get All Clinic Cards', 'et_builder' ),
				),
			),
			'advanced' => array(
				'toggles' => array(
					'width' => array(
						'title'    => esc_html__( 'Sizing', 'et_builder' ),
						'priority' => 65,
					),
				),
			),
		);

		$this->advanced_fields = array(
			'margin_padding' => array(
				'css' => array(
					'important' => array( 'custom_margin' ), // needed to overwrite last module margin-bottom styling
				),
			),
			'text_shadow'           => array(
				// Don't add text-shadow fields since they already are via font-options
				'default' => false,
			),
			'fonts'                 => false,
			'button'                => false,
		);

		$this->help_videos = array(
			array(
				'id'   => esc_html( 'dTY6-Cbr00A' ),
				'name' => esc_html__( 'An introduction to the Code module', 'et_builder' ),
			),
		);

		// wptexturize is often incorrectly parsed single and double quotes
		// This disables wptexturize on this module
		add_filter( 'no_texturize_shortcodes', array( $this, 'disable_wptexturize' ) );
	}

	function get_fields() {
		$fields = array(
			'post_type' => array(
				'label'           => esc_html__( 'Post Type', 'et_builder' ),
				'type'            => 'text',
				'description'     => esc_html__( 'Enter the post type for the module to get', 'et_builder' ),
				'toggle_slug'     => 'main_content',
			),
			'layout_id' => array(
				'label'           => esc_html__( 'Layout ID', 'et_builder' ),
				'type'            => 'text',
				'description'     => esc_html__( 'Enter the post ID of the global layout to use', 'et_builder' ),
				'toggle_slug'     => 'main_content',
			),
			'col_count' => array(
				'label'           => esc_html__( 'Columns Per Row', 'et_builder' ),
				'type'            => 'select',
				'options'           => array(
					'1'              => '1 Column',
					'2'              => '2 Column',
					'3'              => '3 Column',
					'4'             => '4 Column',
					),
				'description'     => esc_html__( 'Amount of columns per row', 'et_builder' ),
				'toggle_slug'     => 'main_content',
			),
		);

		return $fields;
	}

	function render( $attrs, $content = null, $render_slug ) {
		$multi_view                = et_pb_multi_view_options( $this );
		$post_type = $this->props[ 'post_type' ];
		$layout_id = $this->props[ 'layout_id' ];
		$col_count = ( $this->props[ 'col_count' ] ) ? $this->props[ 'col_count' ] : '3';

		// Module classnames
		$this->add_classname( $this->get_text_orientation_classname() );

		
		
		$post_array = array();
		// WP_Query arguments
		$args = array(
			'post_type'              => $post_type,
			'posts_per_page'         => '-1',
			'orderby'				=> 'title',
			'order'					=> 'ASC',
		);

		// The Query
		$query = new WP_Query( $args );

		// The Loop
		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
				$post_array[] = $query->post->ID;
			}
		} else {
			// no posts found
			$post_array = array();
		}

		// Restore original Post Data
		wp_reset_postdata();
		
		
		$rendered_shortcodes = array();

		$layout_shortcode = get_post_field('post_content', $layout_id);
		foreach( $post_array as $cur_post ){
			global $post;
			$post = get_post( $cur_post, OBJECT );
			if( isset( $post->post_name ) ){
				$the_post_name = $post->post_name;	
			}else{
				$the_post_name = 'post';
			}
				setup_postdata( $post );
 				// No the below is not a mistake. I need to call do_shortcode twice to allow the initial DIVI shortcodes to register my custom shortcodes within them.
				$shortcode_initial_render = do_shortcode( $layout_shortcode );
				$rendered_shortcodes[ $the_post_name ] = do_shortcode( $shortcode_initial_render );
				wp_reset_postdata();
			
		}
		
		switch( $col_count ){
			case '1':
				$new_row_cols = '4_4';
				$col_type = '4_4';
				break;
			case '2':
				$new_row_cols = '1_2,1_2';
				$col_type = '1_2';
				break;
			case '3':
				$new_row_cols = '1_3,1_3,1_3';
				$col_type = '1_3';
				break;
			case '4':
				$new_row_cols = '1_4,1_4,1_4,1_4';
				$col_type = '1_4';
				break;
			default:
				$new_row_cols = '1_3,1_3,1_3';
				$col_type = '1_3';
				break;
		}
		$i = 0;
		//$shortcode = '[et_pb_row column_structure="' . $new_row_cols . '"]';
		$shortcode = '<div class="et_pb_row aow-' . $post_type . '-card-row">';
		$closed = FALSE;
		foreach( $rendered_shortcodes as $postid => $rendered_shortcode ){
			$i++;
			if( $closed ){
				//$shortcode .= '[et_pb_row column_structure="' . $new_row_cols . '"]';
				$shortcode .= '<div class="et_pb_row aow-' . $post_type . '-card-row">';
			}
			$closed = FALSE;
			$shortcode .= '<div class="et_pb_column et_pb_column_' . $col_type . '" id="' . $postid . '">';
			$shortcode .= $rendered_shortcode;
			$shortcode .= '</div>';
			if( $i % $col_count == 0 ){
				//$shortcode .= '[/et_pb_row]';
				$shortcode .= '</div>';
				$closed = TRUE;
			}
			
		}
		if( !$closed ){
			//$shortcode .= '[/et_pb_row]';
				$shortcode .= '</div>';
		}
		
		$content .= do_shortcode( $shortcode );
		
		$raw_content = $content;
		$output = sprintf(
			'<div%2$s class="%3$s">
				%1$s
			</div> <!-- .et_pb_code -->',
			$raw_content,
			$this->module_id(),
			$this->module_classname( $render_slug )
		);
		
		return $output;
	}

	/**
	 * Filter multi view value.
	 *
	 * @since 3.27.1
	 * 
	 * @see ET_Builder_Module_Helper_MultiViewOptions::filter_value
	 *
	 * @param mixed $raw_value Props raw value.
	 * @param array $args {
	 *     Context data.
	 *
	 *     @type string $context      Context param: content, attrs, visibility, classes.
	 *     @type string $name         Module options props name.
	 *     @type string $mode         Current data mode: desktop, hover, tablet, phone.
	 *     @type string $attr_key     Attribute key for attrs context data. Example: src, class, etc.
	 *     @type string $attr_sub_key Attribute sub key that availabe when passing attrs value as array such as styes. Example: padding-top, margin-botton, etc.
	 * }
	 *
	 * @return mixed
	 */
	/*
	public function multi_view_filter_value( $raw_value, $args ) {
		$name = isset( $args['name'] ) ? $args['name'] : '';
		$mode = isset( $args['mode'] ) ? $args['mode'] : 'desktop';

		if ( $raw_value && 'raw_content' === $name ) {
			if ( 'desktop' !== $mode ) {
				$raw_value = et_builder_convert_line_breaks( et_builder_replace_code_content_entities( $raw_value ) );
			}

			$raw_value = $this->fix_wptexturized_scripts( $raw_value );
		}

		return $raw_value;
	}
	*/
}

new ET_Builder_Module_Aow_Custom;
