<?php
class ET_Builder_Module_Aow_Get_Clinic_Rel extends ET_Builder_Module {
	function init() {
		$this->name            = esc_html__( 'AOW HUB NODE - Get Related Post', 'et_builder' );
		$this->plural          = esc_html__( 'AOW HUB NODE - Get Related Posts', 'et_builder' );
		$this->slug            = 'et_pb_aow_hub_node_get_related_posts';
		$this->vb_support      = 'on';
		$this->use_raw_content = true;

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'main_content' => esc_html__( 'AOW HUB NODE - Get All Related', 'et_builder' ),
				),
			),
			'advanced' => array(
				'toggles' => array(
					'width' => array(
						'title'    => esc_html__( 'Sizing', 'et_builder' ),
						'priority' => 65,
					),
				),
			),
		);

		$this->advanced_fields = array(
			'margin_padding' => array(
				'css' => array(
					'important' => array( 'custom_margin' ), // needed to overwrite last module margin-bottom styling
				),
			),
			'text_shadow'           => array(
				// Don't add text-shadow fields since they already are via font-options
				'default' => false,
			),
			'fonts'                 => false,
			'button'                => false,
		);

		$this->help_videos = array(
			array(
				'id'   => esc_html( 'dTY6-Cbr00A' ),
				'name' => esc_html__( 'An introduction to the Code module', 'et_builder' ),
			),
		);

		// wptexturize is often incorrectly parsed single and double quotes
		// This disables wptexturize on this module
		add_filter( 'no_texturize_shortcodes', array( $this, 'disable_wptexturize' ) );
	}

	function get_fields() {
		$fields = array(
			'post_type' => array(
				'label'           => esc_html__( 'Post Type of Related', 'et_builder' ),
				'type'            => 'text',
				'description'     => esc_html__( 'Enter the post type for the module to get', 'et_builder' ),
				'toggle_slug'     => 'main_content',
			),
			'meta_field' => array(
				'label'           => esc_html__( 'Meta Field to get relationship from', 'et_builder' ),
				'type'            => 'text',
				'description'     => esc_html__( 'blarg I\'m getting tired of entering descriptions', 'et_builder' ),
				'toggle_slug'     => 'main_content',
			),
			'post_id' => array(
				'label'           => esc_html__( 'ID of Post To Get Related From', 'et_builder' ),
				'type'            => 'text',
				'description'     => esc_html__( 'Enter the post type for the module to get', 'et_builder' ),
				'toggle_slug'     => 'main_content',
			),
			'layout_id' => array(
				'label'           => esc_html__( 'Layout ID', 'et_builder' ),
				'type'            => 'text',
				'description'     => esc_html__( 'Enter the post ID of the global layout to use', 'et_builder' ),
				'toggle_slug'     => 'main_content',
			),
			'col_count' => array(
				'label'           => esc_html__( 'Columns Per Row', 'et_builder' ),
				'type'            => 'select',
				'options'           => array(
					'1'              => '1 Column',
					'2'              => '2 Column',
					'3'              => '3 Column',
					'4'             => '4 Column',
					),
				'description'     => esc_html__( 'Amount of columns per row', 'et_builder' ),
				'toggle_slug'     => 'main_content',
			),
		);

		return $fields;
	}

	function render( $attrs, $content = null, $render_slug ) {
		$multi_view = et_pb_multi_view_options( $this );
		$post_type = $this->props[ 'post_type' ];
		$meta_field = $this->props[ 'meta_field' ];
		$post_id = $this->props[ 'post_id' ];
		$layout_id = $this->props[ 'layout_id' ];
		$col_count = ( $this->props[ 'col_count' ] ) ? $this->props[ 'col_count' ] : '3';

		// Module classnames
		$this->add_classname( $this->get_text_orientation_classname() );
		
		if( $post_id == 'this' ){
			global $post;
			if( $post ){
				$post_id = $post->ID;
			}
		}
		
		$clinic_rels = get_post_meta( $post_id, $meta_field );
		$clinic_rels = $clinic_rels[0];
		//return print_r( $clinic_rels, true );
		$post_array = array();
		if( !empty( $clinic_rels ) ){
			// WP_Query arguments
			$args = array(
				'post__in'				=> $clinic_rels,
				'post_type'             => $post_type,
				'posts_per_page'        => '-1',
			);

			// The Query
			$query = new WP_Query( $args );

			// The Loop
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					$post_array[] = $query->post->ID;
				}
			} else {
				// no posts found
			}

			// Restore original Post Data
			wp_reset_postdata();
		}
		
		
		$rendered_shortcodes = array();

		$layout_shortcode = get_post_field('post_content', $layout_id);
		foreach( $post_array as $cur_post ){
			global $post; 
			$post = get_post( $cur_post, OBJECT );
			setup_postdata( $post );
			$rendered_shortcodes[] = do_shortcode( $layout_shortcode );
			wp_reset_postdata();
		}
		
		switch( $col_count ){
			case '1':
				$new_row_cols = '1_1';
				$col_type = '1_1';
				break;
			case '2':
				$new_row_cols = '1_2,1_2';
				$col_type = '1_2';
				break;
			case '3':
				$new_row_cols = '1_3,1_3,1_3';
				$col_type = '1_3';
				break;
			case '4':
				$new_row_cols = '1_4,1_4,1_4,1_4';
				$col_type = '1_4';
				break;
			default:
				$new_row_cols = '1_3,1_3,1_3';
				$col_type = '1_3';
				break;
		}
		$i = 0;
		//$shortcode = '[et_pb_row column_structure="' . $new_row_cols . '"]';
		$shortcode = '<div class="et_pb_row aow-' . $post_type . '-card-row">';
		$closed = FALSE;
		foreach( $rendered_shortcodes as $rendered_shortcode ){
			$i++;
			if( $closed ){
				//$shortcode .= '[et_pb_row column_structure="' . $new_row_cols . '"]';
				$shortcode .= '<div class="et_pb_row aow-' . $post_type . '-card-row">';
			}
			$closed = FALSE;
			$shortcode .= '[et_pb_column type="' . $col_type . '"]';
			$shortcode .= $rendered_shortcode;
			$shortcode .= '[/et_pb_column]';
			if( $i % $col_count == 0 ){
				//$shortcode .= '[/et_pb_row]';
				$shortcode .= '</div>';
				$closed = TRUE;
			}
			
		}
		if( !$closed ){
			//$shortcode .= '[/et_pb_row]';
				$shortcode .= '</div>';
		}
		
		$content .= do_shortcode( $shortcode );
		
		$raw_content = $content;
		$output = sprintf(
			'<div%2$s class="%3$s">
				%1$s
			</div> <!-- .et_pb_code -->',
			$raw_content,
			$this->module_id(),
			$this->module_classname( $render_slug )
		);
		return $output;
	}

	/**
	 * Filter multi view value.
	 *
	 * @since 3.27.1
	 * 
	 * @see ET_Builder_Module_Helper_MultiViewOptions::filter_value
	 *
	 * @param mixed $raw_value Props raw value.
	 * @param array $args {
	 *     Context data.
	 *
	 *     @type string $context      Context param: content, attrs, visibility, classes.
	 *     @type string $name         Module options props name.
	 *     @type string $mode         Current data mode: desktop, hover, tablet, phone.
	 *     @type string $attr_key     Attribute key for attrs context data. Example: src, class, etc.
	 *     @type string $attr_sub_key Attribute sub key that availabe when passing attrs value as array such as styes. Example: padding-top, margin-botton, etc.
	 * }
	 *
	 * @return mixed
	 */
	/*
	public function multi_view_filter_value( $raw_value, $args ) {
		$name = isset( $args['name'] ) ? $args['name'] : '';
		$mode = isset( $args['mode'] ) ? $args['mode'] : 'desktop';

		if ( $raw_value && 'raw_content' === $name ) {
			if ( 'desktop' !== $mode ) {
				$raw_value = et_builder_convert_line_breaks( et_builder_replace_code_content_entities( $raw_value ) );
			}

			$raw_value = $this->fix_wptexturized_scripts( $raw_value );
		}

		return $raw_value;
	}
	*/
}

new ET_Builder_Module_Aow_Get_Clinic_Rel;
