<?php

class aow_divi_cip_test extends ET_Builder_Module {
	function init() {
		$this->name       = esc_html__( 'AOW DIVI CIP Test', 'et_builder' );
		$this->slug       = 'et_pb_aow_divi_cip_test';
		$this->vb_support = 'partial';

		$this->settings_modal_toggles = array(
			'general' => array(
				'toggles' => array(
					'main_settings' => esc_html__( 'Main Settings', 'et_builder' ),
				),
			),
		);

		$this->fields_defaults  = array();
		$this->main_css_element = '%%order_class%%';
		
		$this->advanced_fields = array(
			'fonts'                 => array(
				'text'     => array(
					'label'       => esc_html__( 'Value', 'et_builder' ),
					'css'         => array(
						'main' => "{$this->main_css_element} .sb_mod_acf_single_item p, {$this->main_css_element} .sb_mod_acf_single_item",
					),
					'font_size'   => array( 'default' => '14px' ),
					'line_height' => array( 'default' => '1.5em' ),
				),
				'headings' => array(
					'label'       => esc_html__( 'Headings', 'et_builder' ),
					'css'         => array(
						'main' => "{$this->main_css_element} h2.acf_label",
					),
					'font_size'   => array( 'default' => '30px' ),
					'line_height' => array( 'default' => '1.5em' ),
				),
			),
			'background'            => array(
				'settings' => array(
					'color' => 'alpha',
				),
			),
			'border'                => array(),
			'custom_margin_padding' => array(
				'css' => array(
					'important' => 'all',
				),
			),
		);
		
	}
	
	function get_fields() {
		/*
		$options = aow_divi_cip_test_get_fields( false, true );
		
		$image_link_options = array(
			'none'  => 'No Link',
			'image' => 'Larger version',
			'page'  => 'Same Page'
		);

		$image_options = array();
		$sizes         = get_intermediate_image_sizes();

		foreach ( $sizes as $size ) {
			$image_options[ $size ] = $size;
		}

		$multiple_options = array(
			'default' => 'Bullet List',
			'slash'   => ' On one line separated by /',
			'comma'   => ' On one line separated by ,'
		);
		*/
		$fields = array(
			'title'            => array(
				'label'       => esc_html__( 'Title', 'et_builder' ),
				'type'        => 'text',
				'description' => esc_html__( 'The label that will be used for this field on the front end. (Optional)', 'et_builder' ),
				'toggle_slug' => 'main_settings',
			),
			'before'           => array(
				'label'       => esc_html__( 'Before Text', 'et_builder' ),
				'type'        => 'text',
				'description' => esc_html__( 'Text to show before. For example a currency symbol. Note this won\'t show if the field is empty. Shortcodes accepted!', 'et_builder' ),
				'toggle_slug' => 'main_settings',
			),
			'after'            => array(
				'label'       => esc_html__( 'After Text', 'et_builder' ),
				'type'        => 'text',
				'description' => esc_html__( 'Text to show after. For example a label. Note this won\'t show if the field is empty. Shortcodes accepted!', 'et_builder' ),
				'toggle_slug' => 'main_settings',
			),
			'admin_label'      => array(
				'label'       => esc_html__( 'Admin Label', 'et_builder' ),
				'type'        => 'text',
				'description' => esc_html__( 'This will change the label of the module in the builder for easy identification.', 'et_builder' ),
				'toggle_slug' => 'main_settings',
			),
			'module_id'        => array(
				'label'           => esc_html__( 'CSS ID', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'configuration',
				'tab_slug'        => 'custom_css',
				'option_class'    => 'et_pb_custom_css_regular',
			),
			'module_class'     => array(
				'label'           => esc_html__( 'CSS Class', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'configuration',
				'tab_slug'        => 'custom_css',
				'option_class'    => 'et_pb_custom_css_regular',
			),
		);
		
		return $fields;
	}

	function render( $atts, $content = null, $function_name ) {
		if ( ! function_exists( 'get_field' ) ) {
			return;
		}

		$module_id        = $this->props['module_id'];
		$module_class     = $this->props['module_class'];
		//$image_size       = $this->props['image_size'];
		//$date_format      = ( $this->props['date_format'] ? $this->props['date_format'] : get_option( 'date_format' ) );
		//$field_name       = $this->props['field_name'];
		//$link_image       = $this->props['link_image'];
		//$multiples_format = ( $this->props['multiples_format'] ? $this->props['multiples_format'] : 'default' );
		$format_output    = ( @$this->props['format_output'] ? $this->props['format_output'] : 'none' );
		$before           = ( @$this->props['before'] ? $this->props['before'] : '' );
		$after            = ( @$this->props['after'] ? $this->props['after'] : '' );

		$title = $this->props['title'];

		$module_class = ET_Builder_Element::add_module_order_class( $module_class, $function_name );

		//////////////////////////////////////////////////////////////////////

		$output  = '';
		$content = '';
		$value   = '';

		if ( $title ) {
			$content .= '<h2 class="acf_label">' . $title . '</h2>';
		}
		/*
		$query = new WP_Query( array(
  'post_type' => 'et_pb_layout',
  'post_name__in' => array('after-menu')
 ));
 echo do_shortcode('[et_pb_section global_module="' . $query->posts[0]->ID . '"]
                    [/et_pb_section]');
		
		*/
		$post_array = array();
		// WP_Query arguments
		$args = array(
			'post_type'              => array( 'clinic' ),
			'posts_per_page'         => '-1',
		);

		// The Query
		$query = new WP_Query( $args );

		// The Loop
		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				//var_dump( $query ); die();
				$query->the_post();
				//var_dump( $query->post );
				$post_array[] = $query->post->ID;
				//$query->the_post();
				// do something
			}
		} else {
			// no posts found
		}

		// Restore original Post Data
		wp_reset_postdata();
		
		
		$rendered_shortcodes = array();
//var_dump( $post_array ); die();
		//var_dump( get_post_field('post_content', '231247') ); die();
		$layout_shortcode = get_post_field('post_content', '232263');
		foreach( $post_array as $cur_post ){
			global $post; 
			$post = get_post( $cur_post, OBJECT );
			setup_postdata( $post );
			$rendered_shortcodes[] = do_shortcode( $layout_shortcode );
			wp_reset_postdata();
		}
		$new_row_col_count = '3';
		switch( $new_row_col_count ){
			case '3':
				$new_row_cols = '1_3,1_3,1_3';
				$col_type = '1_3';
				break;
			case '4':
				$new_row_cols = '1_4,1_4,1_4,1_4';
				$col_type = '1_4';
				break;
		}
		$new_row_open = '[et_pb_row column_structure="' . $new_row_cols . '"]';
		$new_row_close = '[/et_pb_row]';
		$shortcode = '';
		//$shortcode  = '[et_pb_section]';
		//$shortcode .= $new_row_open;
		$i = 0;
		$unclosed = TRUE;
		foreach( $rendered_shortcodes as $rendered_shortcode ){		
			$i++;
			$unclosed = TRUE;
			$shortcode .= '[et_pb_column type="' . $col_type . '" module_class="test"]';
			$shortcode .= $rendered_shortcode;
			$shortcode .= '[/et_pb_column]';
			/*
			if( $i % 3 == 0 ){
				$shortcode .= $new_row_close . $new_row_open;
				$unclosed = FALSE;
			}*/
		}
		//if( $unclosed){ $shortcode .= $new_row_close; }
		//$shortcode .= '[/et_pb_section]';
		
		$content .= do_shortcode( $shortcode );
		//$content .= 'test';
		//return $content;
		/*
		if ( aow_divi_cip_field_is_vb() ) {
			$value   = 'Example text. Your field will show outside of the Visual Builder';
			$content .= '<div class="sb_mod_acf_single_item clearfix">' . $value . '</div>';

		} else {

			if ( $field_arr = explode( '|', $field_name ) ) {
				$field_name = $field_arr[1];
			}

			$qo         = aow_get_queried_object();
			$additional = aow_divi_cip_field_get_id();

			$field = false;

			if ( is_a( $qo, 'WP_Term' ) ) {
				$additional_term = trim( $qo->taxonomy . '_' . $qo->term_id );
				$field           = get_field_object( $field_name, $additional_term );
			} //future add support for user pages and maybe options pages.

			if ( ! $field ) {
				$field = get_field_object( $field_name, $additional );
			}

			if ( $field ) {

				$value = aow_divi_cip_parse_value_by_type( $field, $image_size, false, $date_format, $link_image, $multiples_format );

				if ( trim( $value ) ) {
					if ( $format_output != 'none' ) {
						$value = aow_divi_cip_format_output( $value, $this->props, $field );
					}

					$value = do_shortcode( $before . $value . $after );

					$content .= '<div class="sb_mod_acf_single_item clearfix">' . $value . '</div>';
				} else {
					$content = '';
				}
			}
			
		}*/

//////////////////////////////////////////////////////////////////////
/*
		if ( trim( $content ) && trim( $value ) ) {
			$output = sprintf(
				'<div%5$s class="%1$s%3$s%6$s">
												%2$s
										%4$s',
				'clearfix ',
				$content,
				esc_attr( 'et_pb_module' ),
				'</div>',
				( '' !== $module_id ? sprintf( ' id="%1$s"', esc_attr( $module_id ) ) : '' ),
				( '' !== $module_class ? sprintf( ' %1$s', esc_attr( $module_class ) ) : '' )
			);
		}
*/
		$output = $content;
		return $output;
	}
}

new aow_divi_cip_test;

?>
