<?php

/**
 * The sub-class that manages the clinic custom post type
 *
 * @link       https://aheadoftheweb.com/
 * @since      1.0.0
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 */

/**
 * The sub-class that manages the clinic custom post type
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/admin
 * @author     Graeme <Gibson>
 */
class Aow_Hub_Node_CPT_Service extends Aow_Hub_Node_CPT {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;
	
	/**
	 * ID, Text Domain
	 *
	 * @var string
	 * @since  1.2.0
	 */
	protected $ID = 'clinic-service';
	
	public $posttype = 'clinic-service';

	public $singular = 'Service';
	
	public $key = 'serviceid';
	
	public $name = 'service_name';
	
	public $posttablename = 'aow_hub_services';

	/**
	 * Menu Slug
	 *
	 * @var string
	 * @since  1.2.0
	 */
	public $menuSlug = 'service-settings';


	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin ) {
		$this->admin = $plugin;
		parent::__construct(
			array( __( 'Clinic Service', $this->ID ), __( 'Clinic Services', $this->ID ), $this->ID ),
			array( 'supports' => array( 'title', 'editor', 'excerpt', 'thumbnail' ), 
				   'rewrite'	  => array(
					  'slug'                  => 'clinic-services',
					  'with_front'            => true,
					  'pages'                 => false,
					  'feeds'                 => false,
		  			),
					'show_in_nav_menus'		=>true,
			)
		);
		
	}
	
	public function get_meta( $cip ){
		$meta_fields = array(
			'cip'		=> json_encode( $cip ),
			'serviceid'	=> $cip->id,
			'service_name'	=> $cip->service_name,
		);
		return $meta_fields;
	}

}
?>