<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://aheadoftheweb.com/
 * @since      1.0.0
 *
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Aow_Hub_Node
 * @subpackage Aow_Hub_Node/includes
 * @author     Graeme <Gibson>
 */
class Aow_Hub_Node {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Aow_Hub_Node_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;
	
	/**
	 * Manages the connection to the network.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      AowHubNodeConnection    $version    The current version of the plugin.
	 */
	protected $connection;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'AOW_HUB_NODE_VERSION' ) ) {
			$this->version = AOW_HUB_NODE_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'aow-hub-node';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Aow_Hub_Node_Loader. Orchestrates the hooks of the plugin.
	 * - Aow_Hub_Node_i18n. Defines internationalization functionality.
	 * - Aow_Hub_Node_Admin. Defines all hooks for the admin area.
	 * - Aow_Hub_Node_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
		 * The class responsible for managing custom post types
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-aow-hub-node-cpt.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'post-types/class-aow-hub-node-cpt-city.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'post-types/class-aow-hub-node-cpt-clinic.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'post-types/class-aow-hub-node-cpt-language.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'post-types/class-aow-hub-node-cpt-staff.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'post-types/class-aow-hub-node-cpt-service.php';
		
		/**
		 * The class responsible for managing interations with the database
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-aow-hub-node-data.php';
		
		/**
		 * The class responsible for managing helper functions
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-aow-hub-node-helper.php';
		
		/**
		 * The class responsible for managing widgets
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-aow-hub-node-widget-clinic-hours.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-aow-hub-node-widget-clinic-promotions.php';
		
		/**
		 * The class responsible for connecting to the network endpoint
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-aow-hub-node-connection.php';
		
		/**
		 * The class responsible for creating and managing the customizer functionality
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-aow-hub-node-customizer.php';
		
		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-aow-hub-node-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-aow-hub-node-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-aow-hub-node-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-aow-hub-node-public.php';
		
		
		

		$this->loader = new Aow_Hub_Node_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Aow_Hub_Node_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Aow_Hub_Node_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Aow_Hub_Node_Admin( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		$this->loader->add_action( 'admin_post_get_data', $plugin_admin, 'execute_page_vars' );
		$this->loader->add_action( 'init', $plugin_admin, 'load_cpts' );
		//$hook, $component, $callback, $priority = 10, $accepted_args = 1
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Aow_Hub_Node_Public( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Aow_Hub_Node_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
