<?php

class Aow_Hub_Node_Connection {

	public $endpoint;
	
	private $admin;
	
	public function __construct( $admin ) {
	$this->admin = $admin;
	}
	
	
	public function connect( $key ){
		
		$c = curl_init();
		curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($c, CURLOPT_URL, $this->endpoint . '?' . $key );
		$contents = curl_exec($c);
		curl_close($c);
		if( $contents ){
			return $contents;
		}else{
			return FALSE;
		}
		
		/*
		public function processRemoteData()
		{		
			global $wpdb;

			if( array_key_exists( 'settings-updated', $_GET ) && $_GET['settings-updated'] == 'true') {			
				$options = get_option($this->ID . '_basics');
				if( array_key_exists( 'custom_brand', $options ) && $options['custom_brand'] != '' ){
					$custom_brand = $options['custom_brand'];
				}else{
					$custom_brand = '';
				}
				if($options['clinic_sync'] == 'on') {
					$url = "https://hub.123dentist.com/cip-allclinicsbycustombrand.php?get_all=get_all&custom_brand=$custom_brand";
					//echo $url; die();
					try {
						// CIP server returns invalid json format. So I have to fix it
						$data = json_decode( file_get_contents($url), true);
						//var_dump($this->allCIPsObjects);
						$clinics = array(); // Contains clinics ID and data. Example: array('id' => data{})
						$clinicIds = array(); //contains clinics IDs only

						// Prepare data for later usage
						foreach($data['AllCIPs'] as $k => $v) {
							$cipID = implode("",array_keys($v));
							$clinics[$cipID] = current($v);
							$clinicIds[$cipID] = $clinics[$cipID]['ClinicName'];
							$this->allCIPsObjects[$cipID] = json_decode(json_encode($clinics[$cipID]));
						}
					}catch(Exception $e) {
						echo $e->getMessage();
					}

					if(count($clinics)) {					
						$result = $this->updateFromCIP($clinicIds);

						$this->plugin->setNoticeMessage($result,"updated");

					}else{
						$this->plugin->setNoticeMessage("Could not read data from CIP server.");
					}

				}
			}

		}
		
		*/
		
		
	}
	
	public function get_status( $key = 'authenticate' ){
		
		// Get currently set endpoint
		$endpoint = $this->endpoint;
		
		// Build fresh status array...mmm...smells like new car
		$status = array();
		
		// Set status array based on endpoint
		// If endpoint is set
		if( $endpoint ){
			// Connect to endpoint and pass authentication string
			$data = $this->connect( $key );
				// If there is a result
				if( $data ){
					$data = json_decode( $data );
					$status[ 'status' ] = $data->status->status;
					$status[ 'notice' ] = $data->status->notice;
					$status[ 'msg' ] = $data->status->msg;
				}else{
					// Connection made but no recognized content passed back
					$status[ 'status' ] = 1;
					$status[ 'notice' ] = 'warning';
					$status[ 'msg' ] = 'Endpoint set, but failed to connect to: ' . $this->endpoint;
				}
				return $status;
		}else{
			// No endpoint set
			$status[ 'status' ] = 0;
			$status[ 'notice' ] = 'error';
			$status[ 'msg' ] = 'No network endpoint set.';
		}
		
		// Return status array
		return $status;
	}
	
	public function get_data( $posttype, $node_type = '', $id = FALSE ){
		$data = false;
		if( $node_type == '3' ){
			if( $posttype == 'clinic-single' ){
				$key = 'get=' . $posttype . '&id=' . $id;
			}elseif( $posttype == 'post-single' ){
				
				$posttypeobject = $this->admin->cpt[ $this->admin->current_posttype ];
				$posttablename = $posttypeobject->posttablename;
				$postname = $posttypeobject->name;
				$key = 'get=post-single&id=' . $id . '&posttablename=' . $posttablename . '&postname=' . $postname;
			}else{
				$key = 'get=' . $posttype . '&custom_brand=' . $id;	
			}
		}else{
			$key = 'get=' . $posttype . '&id=' . $id;
		}
		$data = $this->connect( $key );
		return $data;
	}
	
	public function put_data( $data = FALSE, $node_type = FALSE ){
		if( $data && $node_type ){
			if( $node_type == 1 ){
				// We are settting the data for a single clinic
				
				return true;
			}else if( $node_type == 2 ){
				// We are settting the data for multiple clinics
				
				return true;
			}else if( $node_type == 3 ){
				// We are settting the data for a clinic group
				
				return true;
			}
		} 
		return false;
	}
}




/*
// Function to get and store CIP from external location
function aow_cip_fetchcip($cip,$update=false,$msg=''){
	// Get JSON encoded CIP from external location
	
	//$cip_contents = file_get_contents("https://hub.123dentist.com/cip-callback.php?get_cip=".$cip);
    
    // Graeme new test code to fix fopen issues in PHP 7     
    function curl_get_file_contents($URL)
    {
        $c = curl_init();
        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($c, CURLOPT_URL, $URL);
        $contents = curl_exec($c);
        curl_close($c);
        if ($contents) return $contents;
        else return FALSE;
    }
    
    $cip_contents = curl_get_file_contents( "https://hub.123dentist.com/cip-callback.php?get_cip=".$cip );
	
	// Decode JSON into PHP array
	$cip = json_decode($cip_contents);
	$i = 0;
	foreach( $cip->ClinicInfoPackage->OpeningHours->ClinicHours as $h ){
		if( !isset( $h[3] ) ){
			$cip->ClinicInfoPackage->OpeningHours->ClinicHours[ $i ][3] = NULL;
		}
		$i++;
	}
	$cip_contents = json_encode($cip);
	// Check for errors
	if (json_last_error() == JSON_ERROR_NONE):
		// Update locally stored CIP
		update_option('aow_cip_object',$cip_contents);
		// Check if update failed
		if (!$update):
			ob_start();
			header( 'Location: ' . admin_url( 'options-general.php?page=cip-options' ) );
			ob_end_flush();
			die();
		endif;
	// If there is a JSON error
	else:
		if (!$update):
			echo "Error: This is not a valid CIP object!";
		endif;
	endif;
}
*/
?>